/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.DiscriminatorContext;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AnyOfValidator.class);
    private static final String DISCRIMINATOR_REMARK = "and the discriminator-selected candidate schema didn't pass validation";
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();
    private final DiscriminatorContext discriminatorContext;

    public AnyOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ANY_OF, validationContext);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(validationContext.newSchema(schemaLocation.append(i), evaluationPath.append(i), schemaNode.get(i), parentSchema));
        }
        this.discriminatorContext = this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() ? new DiscriminatorContext() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        AnyOfValidator.debug(logger, node, rootNode, instanceLocation);
        CollectorContext collectorContext = executionContext.getCollectorContext();
        ValidatorState state = executionContext.getValidatorState();
        if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
            executionContext.enterDiscriminatorContext(this.discriminatorContext, instanceLocation);
        }
        boolean initialHasMatchedNode = state.hasMatchedNode();
        Set<Object> allErrors = new LinkedHashSet();
        CollectorContext.Scope grandParentScope = collectorContext.enterDynamicScope();
        try {
            int numberOfValidSubSchemas = 0;
            for (JsonSchema schema : this.schemas) {
                Set<Object> errors = Collections.emptySet();
                CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
                try {
                    Set<Object> set;
                    state.setMatchedNode(initialHasMatchedNode);
                    TypeValidator typeValidator = schema.getTypeValidator();
                    if (typeValidator != null && typeValidator.getSchemaType() != JsonType.UNION && !typeValidator.equalsToSchemaType(node)) {
                        allErrors.addAll(typeValidator.validate(executionContext, node, rootNode, instanceLocation));
                        continue;
                    }
                    errors = !state.isWalkEnabled() ? schema.validate(executionContext, node, rootNode, instanceLocation) : schema.walk(executionContext, node, rootNode, instanceLocation, true);
                    if (errors.isEmpty()) {
                        if (!state.hasMatchedNode()) continue;
                        ++numberOfValidSubSchemas;
                    }
                    if (errors.isEmpty() && !this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
                        allErrors.clear();
                        set = errors;
                        return set;
                    }
                    if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && this.discriminatorContext.isDiscriminatorMatchFound()) {
                        if (!errors.isEmpty()) {
                            allErrors.addAll(errors);
                            allErrors.add(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments(DISCRIMINATOR_REMARK)).build());
                        } else {
                            allErrors.clear();
                        }
                        set = errors;
                        return set;
                    }
                    allErrors.addAll(errors);
                }
                finally {
                    CollectorContext.Scope scope = collectorContext.exitDynamicScope();
                    if (!errors.isEmpty()) continue;
                    parentScope.mergeWith(scope);
                }
            }
            Set childNotRequiredErrors = allErrors.stream().filter(error -> !ValidatorTypeCode.REQUIRED.getValue().equals(error.getType())).collect(Collectors.toCollection(LinkedHashSet::new));
            if (numberOfValidSubSchemas >= 1 && childNotRequiredErrors.isEmpty()) {
                allErrors = childNotRequiredErrors;
            }
            if (!this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) return Collections.unmodifiableSet(allErrors);
            if (!this.discriminatorContext.isActive()) return Collections.unmodifiableSet(allErrors);
            LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
            errors.add(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments("based on the provided discriminator. No alternative could be chosen based on the discriminator property")).build());
            Set<ValidationMessage> set = Collections.unmodifiableSet(errors);
            return set;
        }
        finally {
            if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
                executionContext.leaveDiscriminatorContextImmediately(instanceLocation);
            }
            CollectorContext.Scope parentScope = collectorContext.exitDynamicScope();
            if (allErrors.isEmpty()) {
                state.setMatchedNode(true);
                grandParentScope.mergeWith(parentScope);
            }
        }
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(executionContext, node, rootNode, instanceLocation);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(executionContext, node, rootNode, instanceLocation, false);
        }
        return new LinkedHashSet<ValidationMessage>();
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
    }
}

