/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Map;

public abstract class BaseFormatJsonValidator
extends BaseJsonValidator {
    protected final boolean assertionsEnabled;

    public BaseFormatJsonValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, validatorType, validationContext);
        SpecVersion.VersionFlag specification = this.validationContext.getMetaSchema().getSpecification();
        this.assertionsEnabled = specification == null || specification.getVersionFlagValue() < SpecVersion.VersionFlag.V201909.getVersionFlagValue() ? true : this.isFormatAssertionVocabularyEnabled(specification, this.validationContext.getMetaSchema().getVocabularies());
    }

    protected boolean isFormatAssertionVocabularyEnabled(SpecVersion.VersionFlag specification, Map<String, Boolean> vocabularies) {
        if (SpecVersion.VersionFlag.V202012.equals((Object)specification)) {
            String vocabulary = "https://json-schema.org/draft/2020-12/vocab/format-assertion";
            return vocabularies.containsKey(vocabulary);
        }
        if (SpecVersion.VersionFlag.V201909.equals((Object)specification)) {
            String vocabulary = "https://json-schema.org/draft/2019-09/vocab/format";
            return vocabularies.getOrDefault(vocabulary, false);
        }
        return false;
    }

    protected boolean isAssertionsEnabled(ExecutionContext executionContext) {
        if (Boolean.TRUE.equals(executionContext.getExecutionConfig().getFormatAssertionsEnabled())) {
            return true;
        }
        return this.assertionsEnabled;
    }
}

