/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentSchemas
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DependentSchemas.class);
    private final Map<String, JsonSchema> schemaDependencies = new HashMap<String, JsonSchema>();

    public DependentSchemas(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.DEPENDENT_SCHEMAS, validationContext);
        Iterator it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = (String)it.next();
            JsonNode pvalue = schemaNode.get(pname);
            if (!pvalue.isObject() && !pvalue.isBoolean()) continue;
            this.schemaDependencies.put(pname, validationContext.newSchema(schemaLocation.append(pname), evaluationPath.append(pname), pvalue, parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        DependentSchemas.debug(logger, node, rootNode, instanceLocation);
        LinkedHashSet<ValidationMessage> errors = null;
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            Set<ValidationMessage> schemaDependenciesErrors;
            String pname = (String)it.next();
            JsonSchema schema = this.schemaDependencies.get(pname);
            if (schema == null || (schemaDependenciesErrors = schema.validate(executionContext, node, rootNode, instanceLocation)).isEmpty()) continue;
            if (errors == null) {
                errors = new LinkedHashSet<ValidationMessage>();
            }
            errors.addAll(schemaDependenciesErrors);
        }
        return errors == null || errors.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(errors);
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemaDependencies.values());
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(executionContext, node, rootNode, instanceLocation);
        }
        for (JsonSchema schema : this.schemaDependencies.values()) {
            schema.walk(executionContext, node, rootNode, instanceLocation, false);
        }
        return Collections.emptySet();
    }
}

