/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import io.dropwizard.metrics.Snapshot;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HistogramSnapshot
extends Snapshot {
    private static final Logger logger = LoggerFactory.getLogger(HistogramSnapshot.class);
    private final Histogram histogram;

    HistogramSnapshot(@Nonnull Histogram histogram) {
        this.histogram = histogram;
    }

    @Override
    public double getValue(double quantile) {
        return this.histogram.getValueAtPercentile(quantile * 100.0);
    }

    @Override
    public long[] getValues() {
        long[] vals = new long[(int)this.histogram.getTotalCount()];
        int i = 0;
        for (HistogramIterationValue value : this.histogram.recordedValues()) {
            long val = value.getValueIteratedTo();
            int j = 0;
            while ((long)j < value.getCountAddedInThisIterationStep()) {
                vals[i] = val;
                ++i;
                ++j;
            }
        }
        if (i != vals.length) {
            throw new IllegalStateException("Total count was " + this.histogram.getTotalCount() + " but iterating values produced " + vals.length);
        }
        return vals;
    }

    @Override
    public int size() {
        return (int)this.histogram.getTotalCount();
    }

    @Override
    public long getMax() {
        return this.histogram.getMaxValue();
    }

    @Override
    public double getMean() {
        return this.histogram.getMean();
    }

    @Override
    public long getMin() {
        return this.histogram.getMinValue();
    }

    @Override
    public double getStdDev() {
        return this.histogram.getStdDeviation();
    }

    @Override
    public void dump(OutputStream output) {
        PrintWriter p = null;
        try {
            p = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
            for (HistogramIterationValue value : this.histogram.recordedValues()) {
                int j = 0;
                while ((long)j < value.getCountAddedInThisIterationStep()) {
                    p.printf("%d%n", value.getValueIteratedTo());
                    ++j;
                }
            }
        }
        catch (Exception e) {
            if (p != null) {
                p.close();
            }
            logger.error("Exception:", (Throwable)e);
        }
    }
}

