/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.audit.AuditHandler;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.openapi.parameter.ParameterDeserializer;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(OpenApiHandler.class);
    public static final String CONFIG_NAME = "openapi";
    public static final AttachmentKey<Map<String, Object>> DESERIALIZED_QUERY_PARAMETERS = AttachmentKey.create(Map.class);
    public static final AttachmentKey<Map<String, Object>> DESERIALIZED_PATH_PARAMETERS = AttachmentKey.create(Map.class);
    public static final AttachmentKey<Map<String, Object>> DESERIALIZED_HEADER_PARAMETERS = AttachmentKey.create(Map.class);
    public static final AttachmentKey<Map<String, Object>> DESERIALIZED_COOKIE_PARAMETERS = AttachmentKey.create(Map.class);
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    private volatile HttpHandler next;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String httpMethod;
        ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI());
        Optional<NormalisedPath> maybeApiPath = OpenApiHelper.findMatchingApiPath(requestPath);
        if (!maybeApiPath.isPresent()) {
            this.setExchangeStatus(exchange, STATUS_INVALID_REQUEST_PATH, new Object[]{requestPath.normalised()});
            return;
        }
        NormalisedPath openApiPathString = maybeApiPath.get();
        Path path = OpenApiHelper.openApi3.getPath(openApiPathString.original());
        Operation operation = path.getOperation(httpMethod = exchange.getRequestMethod().toString().toLowerCase());
        if (operation == null) {
            this.setExchangeStatus(exchange, STATUS_METHOD_NOT_ALLOWED, new Object[0]);
            return;
        }
        OpenApiOperation openApiOperation = new OpenApiOperation(openApiPathString, path, httpMethod, operation);
        try {
            ParameterDeserializer.deserialize(exchange, openApiOperation);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        String endpoint = openApiPathString.normalised() + "@" + httpMethod.toString().toLowerCase();
        HashMap<String, Object> auditInfo = new HashMap<String, Object>();
        auditInfo.put("endpoint", endpoint);
        auditInfo.put("openapi_operation", openApiOperation);
        exchange.putAttachment(AuditHandler.AUDIT_INFO, auditInfo);
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return OpenApiHelper.openApi3 != null;
    }

    public void register() {
        ModuleRegistry.registerModule((String)OpenApiHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfig(CONFIG_NAME), null);
    }

    protected static Map<String, ?> mergeMaps(Map preferredMap, Map alternativeMap) {
        HashMap mergedMap = new HashMap();
        if (null != alternativeMap) {
            mergedMap.putAll(alternativeMap);
        }
        if (null != preferredMap) {
            mergedMap.putAll(preferredMap);
        }
        return Collections.unmodifiableMap(mergedMap);
    }

    protected static Map<String, Object> nonNullMap(Map<String, Object> map) {
        return null == map ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    public static Map<String, ?> getQueryParameters(HttpServerExchange exchange) {
        return OpenApiHandler.getQueryParameters(exchange, false);
    }

    public static Map<String, ?> getQueryParameters(HttpServerExchange exchange, boolean deserializedValueOnly) {
        Map deserializedQueryParamters = (Map)exchange.getAttachment(DESERIALIZED_QUERY_PARAMETERS);
        return deserializedValueOnly ? OpenApiHandler.nonNullMap(deserializedQueryParamters) : OpenApiHandler.mergeMaps(deserializedQueryParamters, exchange.getQueryParameters());
    }

    public static Map<String, ?> getPathParameters(HttpServerExchange exchange) {
        return OpenApiHandler.getPathParameters(exchange, false);
    }

    public static Map<String, ?> getPathParameters(HttpServerExchange exchange, boolean deserializedValueOnly) {
        Map deserializedPathParamters = (Map)exchange.getAttachment(DESERIALIZED_PATH_PARAMETERS);
        return deserializedValueOnly ? OpenApiHandler.nonNullMap(deserializedPathParamters) : OpenApiHandler.mergeMaps(deserializedPathParamters, exchange.getPathParameters());
    }

    public static Map<String, ?> getHeaderParameters(HttpServerExchange exchange) {
        return OpenApiHandler.getHeaderParameters(exchange, false);
    }

    public static Map<String, ?> getHeaderParameters(HttpServerExchange exchange, boolean deserializedValueOnly) {
        Map deserializedHeaderParamters = (Map)exchange.getAttachment(DESERIALIZED_HEADER_PARAMETERS);
        if (!deserializedValueOnly) {
            HeaderMap headers = exchange.getRequestHeaders();
            if (null == headers) {
                return Collections.emptyMap();
            }
            HashMap<String, HeaderValues> headerMap = new HashMap<String, HeaderValues>();
            for (HttpString headerName : headers.getHeaderNames()) {
                headerMap.put(headerName.toString(), headers.get(headerName));
            }
            return OpenApiHandler.mergeMaps(deserializedHeaderParamters, headerMap);
        }
        return OpenApiHandler.nonNullMap(deserializedHeaderParamters);
    }

    public static Map<String, ?> getCookieParameters(HttpServerExchange exchange) {
        return OpenApiHandler.getCookieParameters(exchange, false);
    }

    public static Map<String, ?> getCookieParameters(HttpServerExchange exchange, boolean deserializedValueOnly) {
        Map deserializedCookieParamters = (Map)exchange.getAttachment(DESERIALIZED_COOKIE_PARAMETERS);
        return deserializedValueOnly ? OpenApiHandler.nonNullMap(deserializedCookieParamters) : OpenApiHandler.mergeMaps(deserializedCookieParamters, exchange.getRequestCookies());
    }
}

