/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.config.Config;
import com.networknt.oas.OpenApiParser;
import com.networknt.oas.model.OpenApi3;
import com.networknt.oas.model.SecurityScheme;
import com.networknt.oas.model.Server;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiHelper {
    static final String OPENAPI_YML_CONFIG = "openapi.yml";
    static final String OPENAPI_YAML_CONFIG = "openapi.yaml";
    static final String OPENAPI_JSON_CONFIG = "openapi.json";
    static final Logger logger = LoggerFactory.getLogger(OpenApiHelper.class);
    public static OpenApi3 openApi3;
    public static String oauth2Name;
    public static String basePath;

    public static Optional<NormalisedPath> findMatchingApiPath(NormalisedPath requestPath) {
        if (openApi3 != null) {
            return openApi3.getPaths().keySet().stream().map(p -> new ApiNormalisedPath((String)p)).filter(p -> OpenApiHelper.pathMatches(requestPath, p)).findFirst();
        }
        return Optional.empty();
    }

    private static String getOAuth2Name() {
        String name = null;
        Map defMap = openApi3.getSecuritySchemes();
        if (defMap != null) {
            for (Map.Entry entry : defMap.entrySet()) {
                if (!((SecurityScheme)entry.getValue()).getType().equals("oauth2")) continue;
                name = (String)entry.getKey();
                break;
            }
        }
        return name;
    }

    private static String getBasePath() {
        int protocolIndex;
        int pathIndex;
        String basePath = "";
        String url = null;
        if (openApi3.getServers().size() > 0) {
            Server server = openApi3.getServer(0);
            url = server.getUrl();
        }
        if (url != null && (pathIndex = url.indexOf(47, (protocolIndex = url.indexOf("://")) + 3)) > 0) {
            basePath = url.substring(pathIndex);
        }
        return basePath;
    }

    private static boolean pathMatches(NormalisedPath requestPath, NormalisedPath apiPath) {
        if (requestPath.parts().size() != apiPath.parts().size()) {
            return false;
        }
        for (int i = 0; i < requestPath.parts().size(); ++i) {
            if (requestPath.part(i).equalsIgnoreCase(apiPath.part(i)) || apiPath.isParam(i)) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            String spec = Config.getInstance().getStringFromFile(OPENAPI_YML_CONFIG);
            if (spec == null && (spec = Config.getInstance().getStringFromFile(OPENAPI_YAML_CONFIG)) == null) {
                spec = Config.getInstance().getStringFromFile(OPENAPI_JSON_CONFIG);
            }
            openApi3 = (OpenApi3)new OpenApiParser().parse(spec, new URL("https://oas.lightapi.net/"));
        }
        catch (MalformedURLException e) {
            logger.error("MalformedURLException", (Throwable)e);
        }
        if (openApi3 == null) {
            logger.error("Unable to load openapi.json");
            throw new RuntimeException("Unable to load openapi.json");
        }
        oauth2Name = OpenApiHelper.getOAuth2Name();
        basePath = OpenApiHelper.getBasePath();
    }
}

