/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi.parameter;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CookieHelper {
    public static final String DOMAIN = "$Domain";
    public static final String VERSION = "$Version";
    public static final String PATH = "$Path";
    private static final char[] HTTP_SEPARATORS;
    private static final boolean[] HTTP_SEPARATOR_FLAGS;
    private static final boolean FWD_SLASH_IS_SEPARATOR;

    public static Map<String, Cookie> parseRequestCookies(int maxCookies, boolean allowEqualInValue, List<String> cookies) {
        return CookieHelper.parseRequestCookies(maxCookies, allowEqualInValue, cookies, false);
    }

    static Map<String, Cookie> parseRequestCookies(int maxCookies, boolean allowEqualInValue, List<String> cookies, boolean commaIsSeperator) {
        return CookieHelper.parseRequestCookies(maxCookies, allowEqualInValue, cookies, commaIsSeperator, true);
    }

    static Map<String, Cookie> parseRequestCookies(int maxCookies, boolean allowEqualInValue, List<String> cookies, boolean commaIsSeperator, boolean allowHttpSepartorsV0) {
        if (cookies == null) {
            return new TreeMap<String, Cookie>();
        }
        TreeMap<String, Cookie> parsedCookies = new TreeMap<String, Cookie>();
        for (String cookie : cookies) {
            CookieHelper.parseCookie(cookie, parsedCookies, maxCookies, allowEqualInValue, commaIsSeperator, allowHttpSepartorsV0);
        }
        return parsedCookies;
    }

    private static void parseCookie(String cookie, Map<String, Cookie> parsedCookies, int maxCookies, boolean allowEqualInValue, boolean commaIsSeperator, boolean allowHttpSepartorsV0) {
        int state = 0;
        String name = null;
        int start = 0;
        boolean containsEscapedQuotes = false;
        int cookieCount = parsedCookies.size();
        HashMap<String, String> cookies = new HashMap<String, String>();
        HashMap<String, String> additional = new HashMap<String, String>();
        block7: for (int i = 0; i < cookie.length(); ++i) {
            char c = cookie.charAt(i);
            switch (state) {
                case 0: {
                    if (c == ' ' || c == '\t' || c == ';') {
                        start = i + 1;
                        continue block7;
                    }
                    state = 1;
                }
                case 1: {
                    if (c == '=') {
                        name = cookie.substring(start, i);
                        start = i + 1;
                        state = 2;
                        continue block7;
                    }
                    if (c != ';' && (!commaIsSeperator || c != ',')) continue block7;
                    if (name != null) {
                        cookieCount = CookieHelper.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                    } else if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
                        UndertowLogger.REQUEST_LOGGER.trace((Object)("Ignoring invalid cookies in header " + cookie));
                    }
                    state = 0;
                    start = i + 1;
                    continue block7;
                }
                case 2: {
                    if (c == ';' || commaIsSeperator && c == ',') {
                        cookieCount = CookieHelper.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                        state = 0;
                        start = i + 1;
                        continue block7;
                    }
                    if (c == '\"' && start == i) {
                        containsEscapedQuotes = false;
                        state = 3;
                        start = i + 1;
                        continue block7;
                    }
                    if (c == '=') {
                        if (allowEqualInValue || allowHttpSepartorsV0) continue block7;
                        cookieCount = CookieHelper.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                        state = 4;
                        start = i + 1;
                        continue block7;
                    }
                    if (allowHttpSepartorsV0 || !CookieHelper.isHttpSeparator(c)) continue block7;
                    cookieCount = CookieHelper.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                    state = 4;
                    start = i + 1;
                    continue block7;
                }
                case 3: {
                    if (c == '\"') {
                        cookieCount = CookieHelper.createCookie(name, containsEscapedQuotes ? CookieHelper.unescapeDoubleQuotes(cookie.substring(start, i)) : cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                        state = 0;
                        start = i + 1;
                    }
                    if (c != '\\' || i + 1 >= cookie.length() || cookie.charAt(i + 1) != '\"' || i + 2 == cookie.length() || i + 2 < cookie.length() && (cookie.charAt(i + 2) == ';' || commaIsSeperator && cookie.charAt(i + 2) == ',')) continue block7;
                    ++i;
                    containsEscapedQuotes = true;
                    continue block7;
                }
                case 4: {
                    if (c == ';' || commaIsSeperator && c == ',') {
                        state = 0;
                    }
                    start = i + 1;
                }
            }
        }
        if (state == 2) {
            CookieHelper.createCookie(name, cookie.substring(start), maxCookies, cookieCount, cookies, additional);
        }
        for (Map.Entry entry : cookies.entrySet()) {
            String path;
            String version;
            CookieImpl c = new CookieImpl((String)entry.getKey(), (String)entry.getValue());
            String domain = (String)additional.get(DOMAIN);
            if (domain != null) {
                c.setDomain(domain);
            }
            if ((version = (String)additional.get(VERSION)) != null) {
                c.setVersion(Integer.parseInt(version));
            }
            if ((path = (String)additional.get(PATH)) != null) {
                c.setPath(path);
            }
            parsedCookies.put(c.getName(), (Cookie)c);
        }
    }

    private static int createCookie(String name, String value, int maxCookies, int cookieCount, Map<String, String> cookies, Map<String, String> additional) {
        if (!name.isEmpty() && name.charAt(0) == '$') {
            if (additional.containsKey(name)) {
                return cookieCount;
            }
            additional.put(name, value);
            return cookieCount;
        }
        if (cookieCount == maxCookies) {
            throw UndertowMessages.MESSAGES.tooManyCookies(maxCookies);
        }
        if (cookies.containsKey(name)) {
            return cookieCount;
        }
        cookies.put(name, value);
        return ++cookieCount;
    }

    private static String unescapeDoubleQuotes(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        char[] tmp = new char[value.length()];
        int dest = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '\\' && i + 1 < value.length() && value.charAt(i + 1) == '\"') {
                ++i;
            }
            tmp[dest] = value.charAt(i);
            ++dest;
        }
        return new String(tmp, 0, dest);
    }

    static boolean isHttpSeparator(char c) {
        if ((c < ' ' || c >= '\u007f') && c != '\t') {
            throw UndertowMessages.MESSAGES.invalidControlCharacter(Integer.toString(c));
        }
        return HTTP_SEPARATOR_FLAGS[c];
    }

    static {
        HTTP_SEPARATOR_FLAGS = new boolean[128];
        FWD_SLASH_IS_SEPARATOR = Boolean.getBoolean("io.undertow.legacy.cookie.FWD_SLASH_IS_SEPARATOR");
        HTTP_SEPARATORS = FWD_SLASH_IS_SEPARATOR ? new char[]{'\t', ' ', '\"', '(', ')', ',', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'} : new char[]{'\t', ' ', '\"', '(', ')', ',', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'};
        for (int i = 0; i < 128; ++i) {
            CookieHelper.HTTP_SEPARATOR_FLAGS[i] = false;
        }
        for (char HTTP_SEPARATOR : HTTP_SEPARATORS) {
            CookieHelper.HTTP_SEPARATOR_FLAGS[HTTP_SEPARATOR] = true;
        }
    }
}

