/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi.parameter;

import com.networknt.oas.model.Parameter;
import com.networknt.oas.model.Schema;
import com.networknt.openapi.parameter.StyleParameterDeserializer;
import com.networknt.openapi.parameter.ValueType;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

class MatrixStyleDeserializer
implements StyleParameterDeserializer {
    MatrixStyleDeserializer() {
    }

    @Override
    public Object deserialize(HttpServerExchange exchange, Parameter parameter, ValueType valueType, boolean exploade) {
        Collection values = (Collection)exchange.getPathParameters().get(parameter.getName());
        String delimiter = exploade ? ";" : ",";
        String start = String.format("%s%s=", ";", parameter.getName());
        if (ValueType.PRIMITIVE == valueType) {
            StringBuilder builder = new StringBuilder();
            values.forEach(v -> builder.append(this.trimStart((String)v, start)));
            return builder.toString();
        }
        if (ValueType.ARRAY == valueType) {
            ArrayList valueList = new ArrayList();
            if (!exploade) {
                values.forEach(v -> valueList.addAll(this.asList(this.trimStart((String)v, start), delimiter)));
            } else {
                String prefix = String.format("%s=", parameter.getName());
                values.forEach(v -> valueList.addAll(this.asList(this.replace(this.trimStart((String)v, ";"), prefix, ""), delimiter)));
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)valueList.get(valueList.size() - 1)))) {
                valueList.remove(valueList.size() - 1);
            }
            return valueList;
        }
        if (ValueType.OBJECT == valueType) {
            HashMap valueMap = new HashMap();
            if (!exploade) {
                values.forEach(v -> valueMap.putAll(this.asMap((String)v, delimiter)));
            } else {
                Schema schema = parameter.getSchema();
                String requestURI = exchange.getRequestURI();
                schema.getProperties().keySet().forEach(k -> valueMap.put(k, this.getValue((String)k, requestURI)));
            }
            return valueMap;
        }
        return null;
    }

    private String getValue(String prop, String uri) {
        String key = String.format(";%s=", prop);
        if (StringUtils.containsIgnoreCase((CharSequence)uri, (CharSequence)key)) {
            String value = uri.substring(uri.indexOf(key) + key.length());
            int nextSemiColon = value.indexOf(";");
            int nextSlash = value.indexOf("/");
            int end = Math.min(nextSemiColon, nextSlash);
            if (nextSemiColon >= 0 && nextSlash >= 0) {
                value = value.substring(0, end);
            } else if (nextSemiColon >= 0) {
                value = value.substring(0, nextSemiColon);
            } else if (nextSlash >= 0) {
                value = value.substring(0, nextSlash);
            }
            return value;
        }
        return "";
    }

    @Override
    public boolean isApplicable(ValueType valueType, boolean exploade) {
        return null != valueType;
    }
}

