/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi.parameter;

import com.networknt.openapi.parameter.LabelStyleDeserializer;
import com.networknt.openapi.parameter.MatrixStyleDeserializer;
import com.networknt.openapi.parameter.SimpleStyleDeserializer;
import com.networknt.openapi.parameter.StyleParameterDeserializer;
import com.networknt.utility.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum PathParameterStyle {
    SIMPLE(new SimpleStyleDeserializer()),
    LABEL(new LabelStyleDeserializer()),
    MATRIX(new MatrixStyleDeserializer());

    private static Map<String, PathParameterStyle> lookup;
    private final StyleParameterDeserializer deserializer;

    private PathParameterStyle(StyleParameterDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    public static PathParameterStyle of(String styleStr) {
        if (StringUtils.isBlank((CharSequence)styleStr)) {
            return SIMPLE;
        }
        return lookup.get(StringUtils.trimToEmpty((String)styleStr).toUpperCase());
    }

    public static boolean is(String styleStr, PathParameterStyle style) {
        return style == PathParameterStyle.of(styleStr);
    }

    public StyleParameterDeserializer getDeserializer() {
        return this.deserializer;
    }

    static {
        lookup = new HashMap<String, PathParameterStyle>();
        for (PathParameterStyle style : PathParameterStyle.values()) {
            lookup.put(style.name(), style);
        }
    }
}

