/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi.parameter;

import com.networknt.openapi.parameter.DeepObjectStyleDeserializer;
import com.networknt.openapi.parameter.FormStyleDeserializer;
import com.networknt.openapi.parameter.PipeDelimitedStyleDeserializer;
import com.networknt.openapi.parameter.SpaceDelimitedStyleDeserializer;
import com.networknt.openapi.parameter.StyleParameterDeserializer;
import com.networknt.utility.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum QueryParameterStyle {
    FORM(new FormStyleDeserializer()),
    SPACEDELIMITED(new SpaceDelimitedStyleDeserializer()),
    PIPEDELIMITED(new PipeDelimitedStyleDeserializer()),
    DEEPOBJECT(new DeepObjectStyleDeserializer());

    private static Map<String, QueryParameterStyle> lookup;
    private final StyleParameterDeserializer deserializer;

    private QueryParameterStyle(StyleParameterDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    public static QueryParameterStyle of(String styleStr) {
        if (StringUtils.isBlank((CharSequence)styleStr)) {
            return FORM;
        }
        return lookup.get(StringUtils.trimToEmpty((String)styleStr).toUpperCase());
    }

    public static boolean is(String styleStr, QueryParameterStyle style) {
        return style == QueryParameterStyle.of(styleStr);
    }

    public StyleParameterDeserializer getDeserializer() {
        return this.deserializer;
    }

    static {
        lookup = new HashMap<String, QueryParameterStyle>();
        for (QueryParameterStyle style : QueryParameterStyle.values()) {
            lookup.put(style.name(), style);
        }
    }
}

