/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi.parameter;

import com.networknt.oas.model.Parameter;
import com.networknt.oas.model.Schema;
import com.networknt.openapi.parameter.ValueType;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface StyleParameterDeserializer {
    public static ValueType getValueType(Parameter parameter) {
        Schema schema = parameter.getSchema();
        if (null != schema) {
            return ValueType.of(schema.getType());
        }
        return null;
    }

    default public Object deserialize(HttpServerExchange exchange, Parameter parameter) {
        boolean exploade;
        ValueType valueType = StyleParameterDeserializer.getValueType(parameter);
        if (!this.isApplicable(valueType, exploade = parameter.isExplode())) {
            return null;
        }
        return this.deserialize(exchange, parameter, valueType, exploade);
    }

    public Object deserialize(HttpServerExchange var1, Parameter var2, ValueType var3, boolean var4);

    default public boolean isApplicable(ValueType valueType, boolean exploade) {
        return null != valueType && ValueType.PRIMITIVE != valueType;
    }

    default public String getFirst(Deque<String> values, String key) {
        if (null != values) {
            return StringUtils.trimToEmpty((String)values.peekFirst());
        }
        return "";
    }

    default public List<String> asList(String str, String delimiter) {
        ArrayList<String> valueList = new ArrayList<String>();
        if (!str.contains(delimiter)) {
            valueList.add(str);
        } else {
            String[] items;
            for (String item : items = str.split("\\" + delimiter)) {
                valueList.add(item);
            }
        }
        return valueList;
    }

    default public Map<String, String> asExploadeMap(String str, String delimiter) {
        String[] items;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (String item : items = str.split("\\" + delimiter)) {
            String[] tokens = item.split("=");
            String key = null;
            String value = null;
            if (tokens.length > 0) {
                key = tokens[0];
            }
            if (tokens.length > 1) {
                value = tokens[1];
            }
            if (!StringUtils.isNotBlank((CharSequence)key)) continue;
            valueMap.put(key, StringUtils.trimToEmpty((String)value));
        }
        return valueMap;
    }

    default public Map<String, String> asMap(String str, String delimiter) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> valueMap = new HashMap<String, String>();
        if (!str.contains(delimiter)) {
            valueMap.put(str, "");
        } else {
            String[] items = str.split("\\" + delimiter);
            int len = items.length / 2;
            int keyIndex = 0;
            int valueIndex = 0;
            for (int i = 0; i < len; ++i) {
                keyIndex = 2 * i;
                valueIndex = 2 * i + 1;
                valueMap.put(items[keyIndex], items[valueIndex]);
            }
            if (valueIndex < items.length - 1) {
                valueMap.put(items[items.length - 1], "");
            }
        }
        return valueMap;
    }

    default public String trimStart(String str, String start) {
        if (StringUtils.isNotBlank((CharSequence)str) && StringUtils.isNotBlank((CharSequence)start) && str.startsWith(start)) {
            int pos = start.length();
            return str.substring(pos);
        }
        return str;
    }

    default public String replace(String str, String target, String replacement) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            return str.replace(target, replacement);
        }
        return str;
    }
}

