/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oas.validator.impl;

import com.networknt.oas.model.OAuthFlow;
import com.networknt.oas.model.SecurityScheme;
import com.networknt.oas.validator.ObjectValidatorBase;
import com.networknt.oas.validator.impl.OAuthFlowValidator;
import java.util.function.Consumer;

public class SecuritySchemeValidator
extends ObjectValidatorBase<SecurityScheme> {
    @Override
    public void runObjectValidations() {
        SecurityScheme securityScheme = (SecurityScheme)this.value.getOverlay();
        this.validateStringField("description", false);
        this.validateStringField("type", true, "apiKey|http|oauth2|openIdConnect");
        String type = securityScheme.getType();
        if (type != null) {
            switch (type) {
                case "http": {
                    this.validateStringField("scheme", true);
                    this.validateStringField("bearerFormat", false);
                    break;
                }
                case "apiKey": {
                    this.validateStringField("name", true);
                    this.validateStringField("in", true, "query|header|cookie");
                    break;
                }
                case "oauth2": {
                    OAuthFlowValidator oauthFlowValidator = new OAuthFlowValidator();
                    this.validateField("implicitOAuthFlow", false, OAuthFlow.class, oauthFlowValidator, new Consumer[0]);
                    this.validateField("passwordOAuthFlow", false, OAuthFlow.class, oauthFlowValidator, new Consumer[0]);
                    this.validateField("clientCredentialsOAuthFlow", false, OAuthFlow.class, oauthFlowValidator, new Consumer[0]);
                    this.validateField("authorizationCodeOAuthFlow", false, OAuthFlow.class, oauthFlowValidator, new Consumer[0]);
                    break;
                }
                case "openIdConnect": {
                    this.validateUrlField("openIdConnectUrl", true, true, false);
                }
            }
        }
        this.validateExtensions(securityScheme.getExtensions());
    }
}

