/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.oas.OpenApiParser;
import com.networknt.oas.model.OpenApi3;
import com.networknt.oas.model.SecurityScheme;
import com.networknt.oas.model.Server;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiHelper {
    static final Logger logger = LoggerFactory.getLogger(OpenApiHelper.class);
    public OpenApi3 openApi3;
    public List<String> oauth2Names;
    public String basePath;

    public OpenApiHelper(String spec) {
        try {
            this.openApi3 = (OpenApi3)new OpenApiParser().parse(spec, new URL("https://oas.lightapi.net/"));
        }
        catch (MalformedURLException e) {
            logger.error("MalformedURLException", (Throwable)e);
        }
        if (this.openApi3 == null) {
            logger.error("Unable to load openapi.json");
            throw new RuntimeException("Unable to load openapi.json");
        }
        this.oauth2Names = this.getOAuth2Name();
        this.basePath = this.getBasePath();
    }

    public static Map<String, Object> merge(Map<String, Object> openapi, Map<String, Object> inject) {
        if (openapi == null) {
            return inject;
        }
        if (inject == null) {
            return openapi;
        }
        for (Map.Entry<String, Object> entry : inject.entrySet()) {
            openapi.merge(entry.getKey(), entry.getValue(), new Merger());
        }
        return openapi;
    }

    public Optional<NormalisedPath> findMatchingApiPath(NormalisedPath requestPath) {
        if (this.openApi3 != null) {
            return this.openApi3.getPaths().keySet().stream().map(p -> new ApiNormalisedPath((String)p, this.basePath)).filter(p -> this.pathMatches(requestPath, (NormalisedPath)p)).findFirst();
        }
        return Optional.empty();
    }

    private List<String> getOAuth2Name() {
        ArrayList<String> names = new ArrayList<String>();
        Map<String, SecurityScheme> defMap = this.openApi3.getSecuritySchemes();
        if (defMap != null) {
            for (Map.Entry<String, SecurityScheme> entry : defMap.entrySet()) {
                if (!entry.getValue().getType().equals("oauth2")) continue;
                names.add(entry.getKey());
            }
        }
        return names;
    }

    private String getBasePath() {
        String basePath = "";
        String url = null;
        if (this.openApi3.getServers().size() > 0) {
            Server server = this.openApi3.getServer(0);
            url = server.getUrl();
        }
        if (url != null) {
            int protocolIndex = url.indexOf("://");
            if (protocolIndex != -1) {
                int pathIndex = url.indexOf(47, protocolIndex + 3);
                if (pathIndex > 0) {
                    basePath = url.substring(pathIndex);
                }
            } else {
                basePath = url.startsWith("/") ? url : "";
            }
        }
        return basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private boolean pathMatches(NormalisedPath requestPath, NormalisedPath apiPath) {
        if (requestPath.parts().size() != apiPath.parts().size()) {
            return false;
        }
        for (int i = 0; i < requestPath.parts().size(); ++i) {
            if (requestPath.part(i).equalsIgnoreCase(apiPath.part(i)) || apiPath.isParam(i)) continue;
            return false;
        }
        return true;
    }

    static class Merger
    implements BiFunction {
        Merger() {
        }

        public Object apply(Object o, Object i) {
            if (o instanceof Map && i instanceof Map) {
                for (Map.Entry entry : ((Map)i).entrySet()) {
                    ((Map)o).merge((String)entry.getKey(), entry.getValue(), new Merger());
                }
            } else if (o instanceof List && i instanceof List) {
                ((List)o).addAll((List)i);
            } else {
                return i;
            }
            return o;
        }
    }
}

