/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.sanitizer;

import com.networknt.body.BodyHandler;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.sanitizer.SanitizerConfig;
import com.networknt.sanitizer.enconding.Encoder;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class SanitizerHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "sanitizer";
    static SanitizerConfig config;
    Encoder encoding;
    private volatile HttpHandler next;

    public SanitizerHandler() {
        config = (SanitizerConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, SanitizerConfig.class);
        this.encoding = new Encoder(config.getEncoding(), config.getAttributesToIgnore(), config.getAttributesToEncode());
    }

    public SanitizerHandler(String configName) {
        config = (SanitizerConfig)Config.getInstance().getJsonObjectConfig(configName, SanitizerConfig.class);
        this.encoding = new Encoder(config.getEncoding(), config.getAttributesToIgnore(), config.getAttributesToEncode());
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Object body;
        HeaderMap headerMap;
        String method = exchange.getRequestMethod().toString();
        if (config.isSanitizeHeader() && (headerMap = exchange.getRequestHeaders()) != null) {
            for (HeaderValues values : headerMap) {
                if (values == null) continue;
                ListIterator itValues = values.listIterator();
                while (itValues.hasNext()) {
                    itValues.set(this.encoding.applyEncoding((String)itValues.next()));
                }
            }
        }
        if (config.isSanitizeBody() && ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method)) && (body = exchange.getAttachment(BodyHandler.REQUEST_BODY)) != null) {
            if (body instanceof List) {
                this.encoding.encodeList((List)body);
            } else {
                this.encoding.encodeNode((Map)body);
            }
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)SanitizerHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }
}

