/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.sanitizer.enconding;

import com.networknt.sanitizer.enconding.Encoding;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Encoder {
    private final Encoding encoding;
    private final List<String> attributesToIgnore;
    private final List<String> attributesToAppreciate;

    public Encoder(Encoding encoding, List<String> attributesToIgnore, List<String> attributesToAppreciate) {
        this.encoding = encoding;
        this.attributesToIgnore = attributesToIgnore == null ? new ArrayList() : attributesToIgnore;
        this.attributesToAppreciate = attributesToAppreciate == null ? new ArrayList() : attributesToAppreciate;
    }

    public void encodeNode(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (this.attributesToIgnore.contains(key) || !this.attributesToAppreciate.isEmpty() && !this.attributesToAppreciate.contains(key)) continue;
            Object value = entry.getValue();
            if (value instanceof String) {
                map.put(key, this.applyEncoding((String)value));
                continue;
            }
            if (value instanceof Map) {
                this.encodeNode((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.encodeList((List)value);
        }
    }

    public void encodeList(List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof String) {
                list.set(i, this.applyEncoding((String)list.get(i)));
                continue;
            }
            if (list.get(i) instanceof Map) {
                this.encodeNode((Map)list.get(i));
                continue;
            }
            if (!(list.get(i) instanceof List)) continue;
            this.encodeList((List)list.get(i));
        }
    }

    public String applyEncoding(String value) {
        return this.encoding.apply(value);
    }
}

