/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.config.Config;
import com.networknt.security.JwtConfig;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.keys.resolvers.X509VerificationKeyResolver;
import org.owasp.encoder.Encode;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class JwtHelper {
    static final XLogger logger = XLoggerFactory.getXLogger(JwtHelper.class);
    public static final String JWT_CONFIG = "jwt";
    public static final String SECURITY_CONFIG = "security";
    public static final String JWT_CERTIFICATE = "certificate";
    public static final String JwT_CLOCK_SKEW_IN_SECONDS = "clockSkewInSeconds";
    public static final String ENABLE_VERIFY_JWT = "enableVerifyJwt";
    static List<X509Certificate> certificates;
    static Map<String, Object> securityConfig;
    static Map<String, Object> jwtConfig;

    public static String getJwt(JwtClaims claims) throws Exception {
        String jwt = null;
        RSAPrivateKey privateKey = (RSAPrivateKey)JwtHelper.getPrivateKey("/config/oauth/primary.jks", "password", "selfsigned");
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey((Key)privateKey);
        jws.setAlgorithmHeaderValue("RS256");
        jwt = jws.getCompactSerialization();
        return jwt;
    }

    public static JwtClaims getDefaultJwtClaims() {
        JwtConfig config = (JwtConfig)Config.getInstance().getJsonObjectConfig(JWT_CONFIG, JwtConfig.class);
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(config.getIssuer());
        claims.setAudience(config.getAudience());
        claims.setExpirationTimeMinutesInTheFuture((float)config.getExpiredInMinutes());
        claims.setGeneratedJwtId();
        claims.setIssuedAtToNow();
        claims.setNotBeforeMinutesInThePast(2.0f);
        claims.setClaim("version", (Object)config.getVersion());
        return claims;
    }

    private static PrivateKey getPrivateKey(String filename, String password, String key) {
        PrivateKey privateKey = null;
        try {
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(JwtHelper.class.getResourceAsStream(filename), password.toCharArray());
            privateKey = (PrivateKey)keystore.getKey(key, password.toCharArray());
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (privateKey == null) {
            logger.error("Failed to retrieve private key from keystore");
        }
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate readCertificate(String filename) throws Exception {
        InputStream inStream = null;
        X509Certificate cert = null;
        try {
            inStream = Config.getInstance().getInputStreamFromFile(filename);
            if (inStream != null) {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)cf.generateCertificate(inStream);
            } else {
                logger.info("Certificate " + Encode.forJava((String)filename) + " not found.");
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ioe) {
                    logger.error("Exception: ", (Throwable)ioe);
                }
            }
        }
        return cert;
    }

    public static String getJwtFromAuthorization(String authorization) {
        String[] parts;
        String jwt = null;
        if (authorization != null && (parts = authorization.split(" ")).length == 2) {
            String scheme = parts[0];
            String credentials = parts[1];
            Pattern pattern = Pattern.compile("^Bearer$", 2);
            if (pattern.matcher(scheme).matches()) {
                jwt = credentials;
            }
        }
        return jwt;
    }

    public static JwtClaims verifyJwt(String jwt) throws InvalidJwtException {
        JwtClaims claims = null;
        for (X509Certificate certificate : certificates) {
            X509VerificationKeyResolver x509VerificationKeyResolver = new X509VerificationKeyResolver(new X509Certificate[]{certificate});
            x509VerificationKeyResolver.setTryAllOnNoThumbHeader(true);
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(((Integer)jwtConfig.get(JwT_CLOCK_SKEW_IN_SECONDS)).intValue()).setSkipDefaultAudienceValidation().setVerificationKeyResolver((VerificationKeyResolver)x509VerificationKeyResolver).build();
            JwtContext jwtContext = jwtConsumer.process(jwt);
            claims = jwtContext.getJwtClaims();
        }
        return claims;
    }

    static {
        securityConfig = Config.getInstance().getJsonMapConfig(SECURITY_CONFIG);
        jwtConfig = (Map)securityConfig.get(JWT_CONFIG);
        certificates = new ArrayList<X509Certificate>();
        List files = (List)jwtConfig.get(JWT_CERTIFICATE);
        try {
            for (String file : files) {
                certificates.add(JwtHelper.readCertificate(file));
            }
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
    }
}

