/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.security.JwtHelper;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class JwtVerifyHandler
implements HttpHandler {
    static final XLogger logger = XLoggerFactory.getXLogger(JwtVerifyHandler.class);
    private volatile HttpHandler next;

    public JwtVerifyHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderMap headerMap = exchange.getRequestHeaders();
        String authorization = headerMap.getFirst(Headers.AUTHORIZATION);
        String jwt = JwtHelper.getJwtFromAuthorization(authorization);
        if (jwt != null) {
            try {
                JwtClaims claims = JwtHelper.verifyJwt(jwt);
                headerMap.add(new HttpString("client_id"), claims.getStringClaimValue("client_id"));
                headerMap.add(new HttpString("user_id"), claims.getStringClaimValue("user_id"));
                headerMap.add(new HttpString("scope"), claims.getStringListClaimValue("scope").toString());
                this.next.handleRequest(exchange);
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
                exchange.setStatusCode(401);
                exchange.endExchange();
            }
        } else {
            exchange.setStatusCode(401);
            exchange.endExchange();
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public JwtVerifyHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }
}

