/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import com.networknt.config.Config;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConfig {
    public static Logger logger = LoggerFactory.getLogger(ServerConfig.class);
    public static final String CONFIG_NAME = "server";
    public static final String IP = "ip";
    public static final String HTTP_PORT = "httpPort";
    public static final String ENABLE_HTTP = "enableHttp";
    public static final String HTTPS_PORT = "httpsPort";
    public static final String ENABLE_HTTPS = "enableHttps";
    public static final String ENABLE_HTTP2 = "enableHttp2";
    public static final String KEYSTORE_NAME = "keystoreName";
    public static final String KEYSTORE_PASS = "keystorePass";
    public static final String KEY_PASS = "keyPass";
    public static final String ENABLE_TWO_WAY_TLS = "enableTwoWayTls";
    public static final String TRUSTSTORE_NAME = "truststoreName";
    public static final String TRUSTSTORE_PASS = "truststorePass";
    public static final String ENABLE_REGISTRY = "enableRegistry";
    public static final String SERVICE_ID = "serviceId";
    public static final String SERVICE_NAME = "serviceName";
    public static final String ENVIRONMENT = "environment";
    public static final String BUILD_NUMBER = "buildNumber";
    public static final String DYNAMIC_PORT = "dynamicPort";
    public static final String MIN_PORT = "minPort";
    public static final String MAX_PORT = "maxPort";
    public static final String BUFFER_SIZE = "bufferSize";
    public static final String IO_THREADS = "ioThreads";
    public static final String WORKER_THREADS = "workerThreads";
    public static final String BACKLOG = "backlog";
    public static final String SHUTDOWN_TIMEOUT = "shutdownTimeout";
    public static final String SHUTDOWN_GRACEFUL_PERIOD = "shutdownGracefulPeriod";
    public static final String ALWAYS_SET_DATE = "alwaysSetDate";
    public static final String ALLOW_UNESCAPED_CHARACTERS_IN_URL = "allowUnescapedCharactersInUrl";
    public static final String SERVER_STRING = "serverString";
    public static final String BOOTSTRAP_STORE_NAME = "bootstrapStoreName";
    public static final String BOOTSTRAP_STORE_PASS = "bootstrapStorePass";
    public static final String MAX_TRANSFER_FILE_SIZE = "maxTransferFileSize";
    public static final String START_ON_REGISTRY_FAILURE = "startOnRegistryFailure";
    public static final String MASK_CONFIG_PROPERTIES = "maskConfigProperties";
    String ip;
    int httpPort;
    boolean enableHttp;
    int httpsPort;
    boolean enableHttps;
    boolean enableHttp2;
    String keystoreName;
    String keystorePass;
    String keyPass;
    boolean enableTwoWayTls;
    String truststoreName;
    String truststorePass;
    boolean enableRegistry;
    String serviceId;
    String serviceName;
    String environment;
    String buildNumber;
    boolean dynamicPort;
    int minPort;
    int maxPort;
    int bufferSize;
    int ioThreads;
    int workerThreads;
    int backlog;
    int shutdownTimeout;
    int shutdownGracefulPeriod;
    boolean alwaysSetDate;
    boolean allowUnescapedCharactersInUrl;
    String serverString;
    String bootstrapStoreName;
    String bootstrapStorePass;
    long maxTransferFileSize;
    boolean startOnRegistryFailure;
    boolean maskConfigProperties;
    private final Config config = Config.getInstance();
    private final Map<String, Object> mappedConfig;
    private static volatile ServerConfig instance;

    private ServerConfig() {
        this.mappedConfig = this.config.getJsonMapConfig(CONFIG_NAME);
        this.load();
    }

    private ServerConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.load();
    }

    private void load() {
        if (this.mappedConfig != null) {
            Object object = this.mappedConfig.get(IP);
            if (object != null) {
                this.ip = (String)object;
            }
            if ((object = this.mappedConfig.get(HTTP_PORT)) != null) {
                this.httpPort = Config.loadIntegerValue((String)HTTP_PORT, (Object)object);
            }
            if ((object = this.mappedConfig.get(ENABLE_HTTP)) != null) {
                this.enableHttp = Config.loadBooleanValue((String)ENABLE_HTTP, (Object)object);
            }
            if ((object = this.mappedConfig.get(HTTPS_PORT)) != null) {
                this.httpsPort = Config.loadIntegerValue((String)HTTPS_PORT, (Object)object);
            }
            if ((object = this.mappedConfig.get(ENABLE_HTTPS)) != null) {
                this.enableHttps = Config.loadBooleanValue((String)ENABLE_HTTPS, (Object)object);
            }
            if ((object = this.mappedConfig.get(ENABLE_HTTP2)) != null) {
                this.enableHttp2 = Config.loadBooleanValue((String)ENABLE_HTTP2, (Object)object);
            }
            if ((object = this.mappedConfig.get(KEYSTORE_NAME)) != null) {
                this.keystoreName = (String)object;
            }
            if ((object = this.mappedConfig.get(KEYSTORE_PASS)) != null) {
                this.keystorePass = (String)object;
            }
            if ((object = this.mappedConfig.get(KEY_PASS)) != null) {
                this.keyPass = (String)object;
            }
            if ((object = this.mappedConfig.get(ENABLE_TWO_WAY_TLS)) != null) {
                this.enableTwoWayTls = Config.loadBooleanValue((String)ENABLE_TWO_WAY_TLS, (Object)object);
            }
            if ((object = this.mappedConfig.get(TRUSTSTORE_NAME)) != null) {
                this.truststoreName = (String)object;
            }
            if ((object = this.mappedConfig.get(TRUSTSTORE_PASS)) != null) {
                this.truststorePass = (String)object;
            }
            if ((object = this.mappedConfig.get(ENABLE_REGISTRY)) != null) {
                this.enableRegistry = Config.loadBooleanValue((String)ENABLE_REGISTRY, (Object)object);
            }
            if ((object = this.mappedConfig.get(SERVICE_ID)) != null) {
                this.serviceId = (String)object;
            }
            if ((object = this.mappedConfig.get(SERVICE_NAME)) != null) {
                this.serviceName = (String)object;
            }
            if ((object = this.mappedConfig.get(ENVIRONMENT)) != null) {
                this.environment = (String)object;
            }
            if ((object = this.mappedConfig.get(BUILD_NUMBER)) != null) {
                this.buildNumber = (String)object;
            }
            if ((object = this.mappedConfig.get(DYNAMIC_PORT)) != null) {
                this.dynamicPort = Config.loadBooleanValue((String)DYNAMIC_PORT, (Object)object);
            }
            if ((object = this.mappedConfig.get(MIN_PORT)) != null) {
                this.minPort = Config.loadIntegerValue((String)MIN_PORT, (Object)object);
            }
            if ((object = this.mappedConfig.get(MAX_PORT)) != null) {
                this.maxPort = Config.loadIntegerValue((String)MAX_PORT, (Object)object);
            }
            if ((object = this.mappedConfig.get(BUFFER_SIZE)) != null) {
                this.bufferSize = Config.loadIntegerValue((String)BUFFER_SIZE, (Object)object);
            }
            if ((object = this.mappedConfig.get(IO_THREADS)) != null) {
                this.ioThreads = Config.loadIntegerValue((String)IO_THREADS, (Object)object);
            }
            if ((object = this.mappedConfig.get(WORKER_THREADS)) != null) {
                this.workerThreads = Config.loadIntegerValue((String)WORKER_THREADS, (Object)object);
            }
            if ((object = this.mappedConfig.get(BACKLOG)) != null) {
                this.backlog = Config.loadIntegerValue((String)BACKLOG, (Object)object);
            }
            if ((object = this.mappedConfig.get(SHUTDOWN_TIMEOUT)) != null) {
                this.shutdownTimeout = Config.loadIntegerValue((String)SHUTDOWN_TIMEOUT, (Object)object);
            }
            if ((object = this.mappedConfig.get(SHUTDOWN_GRACEFUL_PERIOD)) != null) {
                this.shutdownGracefulPeriod = Config.loadIntegerValue((String)SHUTDOWN_GRACEFUL_PERIOD, (Object)object);
            }
            if ((object = this.mappedConfig.get(ALWAYS_SET_DATE)) != null) {
                this.alwaysSetDate = Config.loadBooleanValue((String)ALWAYS_SET_DATE, (Object)object);
            }
            if ((object = this.mappedConfig.get(ALLOW_UNESCAPED_CHARACTERS_IN_URL)) != null) {
                this.allowUnescapedCharactersInUrl = Config.loadBooleanValue((String)ALLOW_UNESCAPED_CHARACTERS_IN_URL, (Object)object);
            }
            if ((object = this.mappedConfig.get(SERVER_STRING)) != null) {
                this.serverString = (String)object;
            }
            if ((object = this.mappedConfig.get(BOOTSTRAP_STORE_NAME)) != null) {
                this.bootstrapStoreName = (String)object;
            }
            if ((object = this.mappedConfig.get(BOOTSTRAP_STORE_PASS)) != null) {
                this.bootstrapStorePass = (String)object;
            }
            if ((object = this.mappedConfig.get(MAX_TRANSFER_FILE_SIZE)) != null) {
                this.maxTransferFileSize = Config.loadLongValue((String)MAX_TRANSFER_FILE_SIZE, (Object)object);
            }
            if ((object = this.mappedConfig.get(START_ON_REGISTRY_FAILURE)) != null) {
                this.startOnRegistryFailure = Config.loadBooleanValue((String)START_ON_REGISTRY_FAILURE, (Object)object);
            }
            if ((object = this.mappedConfig.get(MASK_CONFIG_PROPERTIES)) != null) {
                this.maskConfigProperties = Config.loadBooleanValue((String)MASK_CONFIG_PROPERTIES, (Object)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerConfig getInstance() {
        if (instance != null) return instance;
        Class<ServerConfig> clazz = ServerConfig.class;
        synchronized (ServerConfig.class) {
            if (instance != null) return instance;
            instance = new ServerConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static ServerConfig getInstance(String configName) {
        instance = new ServerConfig(configName);
        return instance;
    }

    public static ServerConfig get(String configName) {
        instance = new ServerConfig(configName);
        return instance;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getHttpPort() {
        String port = System.getProperty(HTTP_PORT);
        if (port != null) {
            try {
                int newPort;
                this.httpPort = newPort = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public boolean isEnableHttp() {
        return this.enableHttp;
    }

    public void setEnableHttp(boolean enableHttp) {
        this.enableHttp = enableHttp;
    }

    public int getHttpsPort() {
        String port = System.getProperty(HTTPS_PORT);
        if (port != null) {
            try {
                int newPort;
                this.httpsPort = newPort = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public boolean isEnableHttps() {
        return this.enableHttps;
    }

    public void setEnableHttps(boolean enableHttps) {
        this.enableHttps = enableHttps;
    }

    public String getKeystoreName() {
        return this.keystoreName;
    }

    public void setKeystoreName(String keystoreName) {
        this.keystoreName = keystoreName;
    }

    public String getTruststoreName() {
        return this.truststoreName;
    }

    public void setTruststoreName(String truststoreName) {
        this.truststoreName = truststoreName;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public void setTruststorePass(String truststorePass) {
        this.truststorePass = truststorePass;
    }

    public boolean isEnableTwoWayTls() {
        return this.enableTwoWayTls;
    }

    public void setEnableTwoWayTls(boolean enableTwoWayTls) {
        this.enableTwoWayTls = enableTwoWayTls;
    }

    public boolean isEnableRegistry() {
        return this.enableRegistry;
    }

    public void setEnableRegistry(boolean enableRegistry) {
        this.enableRegistry = enableRegistry;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isEnableHttp2() {
        return this.enableHttp2;
    }

    public void setEnableHttp2(boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public boolean isDynamicPort() {
        return this.dynamicPort;
    }

    public void setDynamicPort(boolean dynamicPort) {
        this.dynamicPort = dynamicPort;
    }

    public int getMinPort() {
        return this.minPort;
    }

    public void setMinPort(int minPort) {
        this.minPort = minPort;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public void setMaxPort(int maxPort) {
        this.maxPort = maxPort;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public int getShutdownGracefulPeriod() {
        return this.shutdownGracefulPeriod;
    }

    public void setShutdownGracefulPeriod(int shutdownGracefulPeriod) {
        this.shutdownGracefulPeriod = shutdownGracefulPeriod;
    }

    public boolean isAlwaysSetDate() {
        return this.alwaysSetDate;
    }

    public void setAlwaysSetDate(boolean alwaysSetDate) {
        this.alwaysSetDate = alwaysSetDate;
    }

    public String getServerString() {
        return this.serverString;
    }

    public void setServerString(String serverString) {
        this.serverString = serverString;
    }

    public boolean isAllowUnescapedCharactersInUrl() {
        return this.allowUnescapedCharactersInUrl;
    }

    public void setAllowUnescapedCharactersInUrl(boolean allowUnescapedCharactersInUrl) {
        this.allowUnescapedCharactersInUrl = allowUnescapedCharactersInUrl;
    }

    public String getBootstrapStoreName() {
        return this.bootstrapStoreName;
    }

    public void setBootstrapStoreName(String bootstrapStoreName) {
        this.bootstrapStoreName = bootstrapStoreName;
    }

    public String getBootstrapStorePass() {
        return this.bootstrapStorePass;
    }

    public void setBootstrapStorePass(String bootstrapStorePass) {
        this.bootstrapStorePass = bootstrapStorePass;
    }

    public long getMaxTransferFileSize() {
        return this.maxTransferFileSize;
    }

    public void setMaxTransferFileSize(long maxTransferFileSize) {
        this.maxTransferFileSize = maxTransferFileSize;
    }

    public boolean isStartOnRegistryFailure() {
        return this.startOnRegistryFailure;
    }

    public void setStartOnRegistryFailure(boolean startOnRegistryFailure) {
        this.startOnRegistryFailure = startOnRegistryFailure;
    }

    public boolean isMaskConfigProperties() {
        return this.maskConfigProperties;
    }

    public void setMaskConfigProperties(boolean maskConfigProperties) {
        this.maskConfigProperties = maskConfigProperties;
    }
}

