/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.networknt.config.Config;
import com.networknt.info.FullAuditHandler;
import com.networknt.info.ServerInfoConfig;
import com.networknt.info.ServerInfoHandler;
import com.networknt.info.SimpleAuditHandler;
import com.networknt.security.JwtVerifyHandler;
import com.networknt.security.SwaggerHelper;
import com.networknt.server.HandlerProvider;
import com.networknt.server.ServerConfig;
import com.networknt.utility.ModuleRegistry;
import com.networknt.validator.ValidatorConfig;
import com.networknt.validator.ValidatorHandler;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.util.Methods;
import java.util.EnumSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Options;

public class Server {
    static final Logger logger = LoggerFactory.getLogger(Server.class);
    protected static boolean shutdownRequested = false;
    static Undertow server = null;
    static String configName = "server";

    public static void main(String[] args) {
        logger.info("server starts");
        Server.start();
    }

    public static void start() {
        Object object;
        ValidatorConfig validatorConfig;
        Server.configJsonPath();
        Server.addDaemonShutdownHook();
        ServerConfig config = (ServerConfig)Config.getInstance().getJsonObjectConfig(configName, ServerConfig.class);
        HttpHandler handler = null;
        ServiceLoader<HandlerProvider> handlerLoaders = ServiceLoader.load(HandlerProvider.class);
        for (HandlerProvider provider : handlerLoaders) {
            if (!(provider.getHandler() instanceof HttpHandler)) continue;
            handler = provider.getHandler();
        }
        ServerInfoConfig serverInfoConfig = (ServerInfoConfig)Config.getInstance().getJsonObjectConfig("info", ServerInfoConfig.class);
        if (serverInfoConfig.isEnableServerInfo()) {
            ServerInfoHandler serverInfoHandler = new ServerInfoHandler();
            if (handler instanceof RoutingHandler) {
                ((RoutingHandler)handler).add(Methods.GET, "/server/info", (HttpHandler)serverInfoHandler);
                Swagger swagger = SwaggerHelper.swagger;
                Path path = new Path();
                Operation get = new Operation();
                path.set("get", get);
                Map paths = swagger.getPaths();
                paths.put("/server/info", path);
                swagger.setPaths(paths);
                ModuleRegistry.registerModule((String)ServerInfoHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache("info"), null);
            }
        }
        if ((validatorConfig = (ValidatorConfig)Config.getInstance().getJsonObjectConfig("validator", ValidatorConfig.class)).isEnableValidator()) {
            ValidatorHandler validatorHandler = new ValidatorHandler(handler);
            handler = validatorHandler;
            ModuleRegistry.registerModule((String)ValidatorHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache("validator"), null);
        }
        if ((object = Config.getInstance().getJsonMapConfig("audit").get("enableSimpleAudit")) != null && ((Boolean)object).booleanValue()) {
            SimpleAuditHandler simpleAuditHandler = new SimpleAuditHandler(handler);
            handler = simpleAuditHandler;
            ModuleRegistry.registerModule((String)SimpleAuditHandler.class.getName(), (Map)SimpleAuditHandler.config, null);
        }
        if ((object = Config.getInstance().getJsonMapConfig("audit").get("enableFullAudit")) != null && ((Boolean)object).booleanValue()) {
            FullAuditHandler fullAuditHandler = new FullAuditHandler(handler);
            handler = fullAuditHandler;
            ModuleRegistry.registerModule((String)FullAuditHandler.class.getName(), (Map)FullAuditHandler.config, null);
        }
        if ((object = Config.getInstance().getJsonMapConfig("security").get("enableVerifyJwt")) != null && ((Boolean)object).booleanValue()) {
            JwtVerifyHandler jwtVerifyHandler = new JwtVerifyHandler(handler);
            handler = jwtVerifyHandler;
            ModuleRegistry.registerModule((String)JwtVerifyHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache("security"), null);
        }
        server = Undertow.builder().addHttpListener(config.getPort(), config.getIp()).setBufferSize(16384).setIoThreads(Runtime.getRuntime().availableProcessors() * 2).setSocketOption(Options.BACKLOG, (Object)10000).setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false).setServerOption(UndertowOptions.ALWAYS_SET_DATE, (Object)true).setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, (Object)false).setHandler((HttpHandler)Handlers.header((HttpHandler)handler, (String)"Server", (String)"Undertow")).setWorkerThreads(200).build();
        server.start();
    }

    public static void stop() {
        if (server != null) {
            server.stop();
        }
    }

    public static void shutdown() {
        Server.stop();
        logger.info("Cleaning up before server shutdown");
    }

    protected static void addDaemonShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Server.shutdown();
            }
        });
    }

    static void configJsonPath() {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JacksonJsonProvider();
            private final MappingProvider mappingProvider = new JacksonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }
}

