/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.service;

import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceConfig {
    private static final Logger logger = LoggerFactory.getLogger(ServiceConfig.class);
    public static final String CONFIG_NAME = "service";
    public static final String SINGLETONS = "singletons";
    private List<Map<String, Object>> singletons;
    private Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    private ServiceConfig() {
        this(CONFIG_NAME);
    }

    private ServiceConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public static ServiceConfig load() {
        return new ServiceConfig();
    }

    public static ServiceConfig load(String configName) {
        return new ServiceConfig(configName);
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public List<Map<String, Object>> getSingletons() {
        return this.singletons;
    }

    public void setConfigData() {
        if (this.mappedConfig.get(SINGLETONS) instanceof String) {
            String s = (String)this.mappedConfig.get(SINGLETONS);
            if (logger.isTraceEnabled()) {
                logger.trace("singletons = " + s);
            }
            this.singletons = JsonMapper.string2List((String)s);
        } else if (this.mappedConfig.get(SINGLETONS) instanceof List) {
            this.singletons = (List)this.mappedConfig.get(SINGLETONS);
        } else if (logger.isInfoEnabled()) {
            logger.info("singletons missing or wrong type.");
        }
    }
}

