/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import com.networknt.server.ServerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleRegistry {
    private static final Map<String, Object> moduleRegistry = new HashMap<String, Object>();
    private static final Map<String, Object> pluginRegistry = new HashMap<String, Object>();
    private static final List<Map<String, Object>> plugins = new ArrayList<Map<String, Object>>();
    private static final List<String> moduleClasses = new ArrayList<String>();
    private static final List<String> pluginClasses = new ArrayList<String>();

    public static void registerModule(String configName, String moduleClass, Map<String, Object> config, List<String> masks) {
        if (config != null) {
            if (ServerConfig.getInstance().isMaskConfigProperties() && masks != null && !masks.isEmpty()) {
                for (String mask : masks) {
                    ModuleRegistry.maskNode(config, mask);
                }
            }
            moduleRegistry.put(configName + ":" + moduleClass, config);
        } else {
            moduleRegistry.put(configName + ":" + moduleClass, new HashMap());
        }
        if (!moduleClasses.contains(moduleClass)) {
            moduleClasses.add(moduleClass);
        }
    }

    public static Map<String, Object> getModuleRegistry() {
        return moduleRegistry;
    }

    public static void registerPlugin(String pluginName, String pluginVersion, String configName, String pluginClass, Map<String, Object> config, List<String> masks) {
        if (config != null) {
            if (ServerConfig.getInstance().isMaskConfigProperties() && masks != null && !masks.isEmpty()) {
                for (String mask : masks) {
                    ModuleRegistry.maskNode(config, mask);
                }
            }
            pluginRegistry.put(configName + ":" + pluginClass, config);
        }
        HashMap<String, String> plugin = new HashMap<String, String>();
        plugin.put("pluginName", pluginName);
        plugin.put("pluginClass", pluginClass);
        plugin.put("pluginVersion", pluginVersion);
        plugins.add(plugin);
        if (!pluginClasses.contains(pluginClass)) {
            pluginClasses.add(pluginClass);
        }
    }

    public static Map<String, Object> getPluginRegistry() {
        return pluginRegistry;
    }

    public static List<Map<String, Object>> getPlugins() {
        return plugins;
    }

    public static List<String> getModuleClasses() {
        return moduleClasses;
    }

    public static List<String> getPluginClasses() {
        return pluginClasses;
    }

    private static void maskNode(Map<String, Object> map, String mask) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String && key.equals(mask)) {
                map.put(key, "*");
                continue;
            }
            if (value instanceof Map) {
                ModuleRegistry.maskNode((Map)value, mask);
                continue;
            }
            if (!(value instanceof List)) continue;
            ModuleRegistry.maskList((List)value, mask);
        }
    }

    private static void maskList(List list, String mask) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof String && list.get(i).equals(mask)) {
                list.set(i, "*");
                continue;
            }
            if (list.get(i) instanceof Map) {
                ModuleRegistry.maskNode((Map)list.get(i), mask);
                continue;
            }
            if (!(list.get(i) instanceof List)) continue;
            ModuleRegistry.maskList((List)list.get(i), mask);
        }
    }
}

