/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import com.networknt.utility.PathTemplate;
import com.networknt.utility.PathTemplateMatch;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class PathTemplateMatcher<T> {
    private final Map<String, Set<PathTemplateHolder>> pathTemplateMap = new ConcurrentHashMap<String, Set<PathTemplateHolder>>();
    private volatile int[] lengths = new int[0];

    public PathMatchResult<T> match(String path) {
        Object normalizedPath;
        Object object = normalizedPath = "".equals(path) ? "/" : path;
        if (!((String)normalizedPath).startsWith("/")) {
            normalizedPath = "/" + (String)normalizedPath;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        int length = ((String)normalizedPath).length();
        int[] lengths = this.lengths;
        for (int i = 0; i < lengths.length; ++i) {
            PathMatchResult<T> res;
            String part;
            Set<PathTemplateHolder> entry;
            int pathLength = lengths[i];
            if (pathLength == length) {
                PathMatchResult<T> res2;
                Set<PathTemplateHolder> entry2 = this.pathTemplateMap.get(normalizedPath);
                if (entry2 == null || (res2 = this.handleStemMatch(entry2, (String)normalizedPath, params)) == null) continue;
                return res2;
            }
            if (pathLength >= length || (entry = this.pathTemplateMap.get(part = ((String)normalizedPath).substring(0, pathLength))) == null || (res = this.handleStemMatch(entry, (String)normalizedPath, params)) == null) continue;
            return res;
        }
        return null;
    }

    private PathMatchResult<T> handleStemMatch(Set<PathTemplateHolder> entry, String path, Map<String, String> params) {
        for (PathTemplateHolder val : entry) {
            if (val.template.matches(path, params)) {
                return new PathMatchResult(params, val.template.getTemplateString(), val.value);
            }
            params.clear();
        }
        return null;
    }

    public synchronized PathTemplateMatcher<T> add(PathTemplate template, T value) {
        PathTemplateHolder holder;
        Set<PathTemplateHolder> values = this.pathTemplateMap.get(this.trimBase(template));
        TreeSet<Object> newValues = values == null ? new TreeSet() : new TreeSet<PathTemplateHolder>(values);
        if (newValues.contains(holder = new PathTemplateHolder(value, template))) {
            PathTemplate equivalent = null;
            for (PathTemplateHolder pathTemplateHolder : newValues) {
                if (pathTemplateHolder.compareTo(holder) != 0) continue;
                equivalent = pathTemplateHolder.template;
                break;
            }
            throw new RuntimeException(String.format("Cannot add path template %s, matcher already contains an equivalent pattern %s", template.getTemplateString(), equivalent.getTemplateString()));
        }
        newValues.add(holder);
        this.pathTemplateMap.put(this.trimBase(template), newValues);
        this.buildLengths();
        return this;
    }

    private String trimBase(PathTemplate template) {
        String retval = template.getBase();
        if (template.getBase().endsWith("/") && !template.getParameterNames().isEmpty()) {
            return retval.substring(0, retval.length() - 1);
        }
        if (retval.endsWith("*")) {
            return retval.substring(0, retval.length() - 1);
        }
        return retval;
    }

    private void buildLengths() {
        TreeSet<Integer> lengths = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        for (String p : this.pathTemplateMap.keySet()) {
            lengths.add(p.length());
        }
        int[] lengthArray = new int[lengths.size()];
        int pos = 0;
        Iterator iterator = lengths.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            lengthArray[pos++] = i;
        }
        this.lengths = lengthArray;
    }

    public synchronized PathTemplateMatcher<T> add(String pathTemplate, T value) {
        PathTemplate template = PathTemplate.create(pathTemplate);
        return this.add(template, value);
    }

    public synchronized PathTemplateMatcher<T> addAll(PathTemplateMatcher<T> pathTemplateMatcher) {
        for (Map.Entry<String, Set<PathTemplateHolder>> entry : pathTemplateMatcher.getPathTemplateMap().entrySet()) {
            for (PathTemplateHolder pathTemplateHolder : entry.getValue()) {
                this.add(pathTemplateHolder.template, pathTemplateHolder.value);
            }
        }
        return this;
    }

    Map<String, Set<PathTemplateHolder>> getPathTemplateMap() {
        return this.pathTemplateMap;
    }

    public Set<PathTemplate> getPathTemplates() {
        HashSet<PathTemplate> templates = new HashSet<PathTemplate>();
        for (Set<PathTemplateHolder> holders : this.pathTemplateMap.values()) {
            for (PathTemplateHolder holder : holders) {
                templates.add(holder.template);
            }
        }
        return templates;
    }

    public synchronized PathTemplateMatcher<T> remove(String pathTemplate) {
        PathTemplate template = PathTemplate.create(pathTemplate);
        return this.remove(template);
    }

    private synchronized PathTemplateMatcher<T> remove(PathTemplate template) {
        Set<PathTemplateHolder> values = this.pathTemplateMap.get(this.trimBase(template));
        if (values == null) {
            return this;
        }
        TreeSet<PathTemplateHolder> newValues = new TreeSet<PathTemplateHolder>(values);
        Iterator it = newValues.iterator();
        while (it.hasNext()) {
            PathTemplateHolder next = (PathTemplateHolder)it.next();
            if (!next.template.getTemplateString().equals(template.getTemplateString())) continue;
            it.remove();
            break;
        }
        if (newValues.size() == 0) {
            this.pathTemplateMap.remove(this.trimBase(template));
        } else {
            this.pathTemplateMap.put(this.trimBase(template), newValues);
        }
        this.buildLengths();
        return this;
    }

    public synchronized T get(String template) {
        PathTemplate pathTemplate = PathTemplate.create(template);
        Set<PathTemplateHolder> values = this.pathTemplateMap.get(this.trimBase(pathTemplate));
        if (values == null) {
            return null;
        }
        for (PathTemplateHolder next : values) {
            if (!next.template.getTemplateString().equals(template)) continue;
            return next.value;
        }
        return null;
    }

    private final class PathTemplateHolder
    implements Comparable<PathTemplateHolder> {
        final T value;
        final PathTemplate template;

        private PathTemplateHolder(T value, PathTemplate template) {
            this.value = value;
            this.template = template;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!PathTemplateHolder.class.equals(o.getClass())) {
                return false;
            }
            PathTemplateHolder that = (PathTemplateHolder)o;
            return this.template.equals(that.template);
        }

        public int hashCode() {
            return this.template.hashCode();
        }

        @Override
        public int compareTo(PathTemplateHolder o) {
            return this.template.compareTo(o.template);
        }
    }

    public static class PathMatchResult<T>
    extends PathTemplateMatch {
        private final T value;

        public PathMatchResult(Map<String, String> parameters, String matchedTemplate, T value) {
            super(matchedTemplate, parameters);
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }
    }
}

