/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import com.networknt.utility.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigUtils.class);
    public static final String DELIMITOR = "@";
    protected static final String INTERNAL_KEY_FORMAT = "%s %s";

    public static String findServiceEntry(String method, String searchKey, Map<String, Object> mapping) {
        if (logger.isDebugEnabled()) {
            logger.debug("findServiceEntry for " + searchKey + " and method: " + method);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("mapping size: " + mapping.size());
        }
        String result = null;
        for (Map.Entry<String, Object> entry : mapping.entrySet()) {
            String[] tokens = StringUtils.trimToEmpty(entry.getKey()).split(DELIMITOR);
            String ConfigPrefix = tokens[0];
            String ConfigMethod = tokens[1];
            if (logger.isDebugEnabled()) {
                logger.debug("prefix: " + ConfigPrefix);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("method: " + ConfigMethod);
            }
            if (!searchKey.startsWith(ConfigPrefix) || searchKey.length() != ConfigPrefix.length() && searchKey.charAt(ConfigPrefix.length()) != '/' || !method.equals(ConfigMethod)) continue;
            result = entry.getKey();
            break;
        }
        if (result == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("serviceEntry not found!");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("prefix = " + result);
        }
        return result;
    }

    public static String normalisePath(String requestPath) {
        if (!requestPath.startsWith("/")) {
            return "/" + requestPath;
        }
        return requestPath;
    }

    public static String toInternalKey(String key) {
        String[] tokens = StringUtils.trimToEmpty(key).split(DELIMITOR);
        if (tokens.length == 2) {
            return ConfigUtils.toInternalKey(tokens[1], tokens[0]);
        }
        logger.warn("Invalid key {}", (Object)key);
        return key;
    }

    public static String toInternalKey(String method, String path) {
        return String.format(INTERNAL_KEY_FORMAT, method, ConfigUtils.normalisePath(path));
    }

    public static Map<String, Object> normalizeMap(Map<String, Object> map, List<String> keysToNotSort) {
        TreeMap<String, Object> normalizedData = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                List listValue = (List)value;
                if (ConfigUtils.matchesAny(key, keysToNotSort)) {
                    normalizedData.put(key, listValue);
                    continue;
                }
                normalizedData.put(key, ConfigUtils.normalizeList(listValue, keysToNotSort));
                continue;
            }
            if (value instanceof Map) {
                Map nestedMap = (Map)value;
                normalizedData.put(key, ConfigUtils.normalizeMap(nestedMap, keysToNotSort));
                continue;
            }
            normalizedData.put(key, value);
        }
        return normalizedData;
    }

    public static boolean matchesAny(String input, List<String> stringsToMatch) {
        return stringsToMatch.contains(input);
    }

    public static List<?> normalizeList(List<?> list, List<String> keysToNotSort) {
        if (list.isEmpty()) {
            return list;
        }
        if (list.get(0) instanceof String) {
            List<?> stringList = list;
            Collections.sort(stringList);
            return stringList;
        }
        if (list.get(0) instanceof Map) {
            List<?> mapList = list;
            for (int i = 0; i < mapList.size(); ++i) {
                Map map = (Map)mapList.get(i);
                mapList.set(i, ConfigUtils.normalizeMap(map, keysToNotSort));
            }
            return mapList;
        }
        throw new IllegalArgumentException("Unsupported element type in the list");
    }
}

