/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;

public class DateUtil {
    static final DateTimeFormatter ALTERNATE_ISO_8601_DATE_FORMAT = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").toFormatter().withZone(ZoneOffset.UTC);
    static final DateTimeFormatter DATE_TIME_FORMAT_WITHOUT_SECONDS = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm").toFormatter().withZone(ZoneOffset.UTC);
    private static final List<DateTimeFormatter> FORMATTERS = Arrays.asList(DateTimeFormatter.ISO_INSTANT, ALTERNATE_ISO_8601_DATE_FORMAT, DATE_TIME_FORMAT_WITHOUT_SECONDS);

    public static String formatIso8601Date(Instant date) {
        return DateTimeFormatter.ISO_INSTANT.format(date);
    }

    public static Instant parseIso8601Date(String dateString) {
        if (dateString.endsWith("+0000")) {
            dateString = dateString.substring(0, dateString.length() - 5).concat("Z");
        }
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                return DateUtil.parseInstant(dateString, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new DateTimeParseException("Could not parse date: " + dateString, dateString, 0);
    }

    public static long parseIso8601DateToMillis(String dateString) {
        return DateUtil.parseIso8601Date(dateString).toEpochMilli();
    }

    private static Instant parseInstant(String dateString, DateTimeFormatter formatter) {
        return formatter.withZone(ZoneOffset.UTC).parse((CharSequence)dateString, Instant::from);
    }
}

