/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator;

import com.networknt.validator.NormalisedPath;
import com.networknt.validator.SchemaValidator;
import com.networknt.validator.SwaggerOperation;
import com.networknt.validator.ValidatorHandler;
import com.networknt.validator.parameter.ParameterValidators;
import com.networknt.validator.report.MessageResolver;
import com.networknt.validator.report.ValidationReport;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidator {
    static final Logger logger = LoggerFactory.getLogger(RequestValidator.class);
    private final SchemaValidator schemaValidator;
    private final ParameterValidators parameterValidators;
    private final MessageResolver messages;

    public RequestValidator(SchemaValidator schemaValidator, MessageResolver messages) {
        this.schemaValidator = Objects.requireNonNull(schemaValidator, "A schema validator is required");
        this.parameterValidators = new ParameterValidators(schemaValidator, messages);
        this.messages = Objects.requireNonNull(messages, "A message resolver is required");
    }

    public ValidationReport validateRequest(NormalisedPath requestPath, HttpServerExchange exchange, SwaggerOperation swaggerOperation) {
        Objects.requireNonNull(requestPath, "A request path is required");
        Objects.requireNonNull(exchange, "An exchange is required");
        Objects.requireNonNull(swaggerOperation, "An swagger operation is required");
        InputStream is = exchange.getInputStream();
        String body = null;
        if (is != null) {
            try {
                if (is.available() != -1) {
                    body = new Scanner(is, "UTF-8").useDelimiter("\\A").next();
                    exchange.putAttachment(ValidatorHandler.REQUEST_BODY, (Object)body);
                }
            }
            catch (IOException e) {
                logger.error("IOException: ", (Throwable)e);
            }
        }
        return this.validatePathParameters(requestPath, swaggerOperation).merge(this.validateRequestBody(Optional.ofNullable(body), swaggerOperation)).merge(this.validateQueryParameters(exchange, swaggerOperation));
    }

    private ValidationReport validateRequestBody(Optional<String> requestBody, SwaggerOperation swaggerOperation) {
        Optional<Parameter> bodyParameter = swaggerOperation.getOperation().getParameters().stream().filter(p -> p.getIn().equalsIgnoreCase("body")).findFirst();
        if (requestBody.isPresent() && !requestBody.get().isEmpty() && !bodyParameter.isPresent()) {
            return ValidationReport.singleton(this.messages.get("validation.request.body.unexpected", swaggerOperation.getMethod(), swaggerOperation.getPathString().original()));
        }
        if (!bodyParameter.isPresent()) {
            return ValidationReport.empty();
        }
        if (!requestBody.isPresent() || requestBody.get().isEmpty()) {
            if (bodyParameter.get().getRequired()) {
                return ValidationReport.singleton(this.messages.get("validation.request.body.missing", swaggerOperation.getMethod(), swaggerOperation.getPathString().original()));
            }
            return ValidationReport.empty();
        }
        return this.schemaValidator.validate(requestBody.get(), ((BodyParameter)bodyParameter.get()).getSchema());
    }

    private ValidationReport validatePathParameters(NormalisedPath requestPath, SwaggerOperation swaggerOperation) {
        ValidationReport validationReport = ValidationReport.empty();
        for (int i = 0; i < swaggerOperation.getPathString().parts().size(); ++i) {
            if (!swaggerOperation.getPathString().isParam(i)) continue;
            String paramName = swaggerOperation.getPathString().paramName(i);
            String paramValue = requestPath.part(i);
            Optional<Parameter> parameter = swaggerOperation.getOperation().getParameters().stream().filter(p -> p.getIn().equalsIgnoreCase("PATH")).filter(p -> p.getName().equalsIgnoreCase(paramName)).findFirst();
            if (!parameter.isPresent()) continue;
            validationReport = validationReport.merge(this.parameterValidators.validate(paramValue, parameter.get()));
        }
        return validationReport;
    }

    private ValidationReport validateQueryParameters(HttpServerExchange exchange, SwaggerOperation swaggerOperation) {
        return swaggerOperation.getOperation().getParameters().stream().filter(p -> p.getIn().equalsIgnoreCase("QUERY")).map(p -> this.validateQueryParameter(exchange, swaggerOperation, (Parameter)p)).reduce(ValidationReport.empty(), ValidationReport::merge);
    }

    private ValidationReport validateQueryParameter(HttpServerExchange exchange, SwaggerOperation swaggerOperation, Parameter queryParameter) {
        Collection queryParameterValues = (Collection)exchange.getQueryParameters().get(queryParameter.getName());
        if (queryParameterValues.isEmpty() && queryParameter.getRequired()) {
            return ValidationReport.singleton(this.messages.get("validation.request.parameter.query.missing", queryParameter.getName(), swaggerOperation.getPathString().original()));
        }
        return queryParameterValues.stream().map(v -> this.parameterValidators.validate((String)v, queryParameter)).reduce(ValidationReport.empty(), ValidationReport::merge);
    }
}

