/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator;

import com.networknt.validator.SchemaValidator;
import com.networknt.validator.SwaggerOperation;
import com.networknt.validator.report.MessageResolver;
import com.networknt.validator.report.MutableValidationReport;
import com.networknt.validator.report.ValidationReport;
import io.swagger.models.Response;
import io.undertow.server.HttpServerExchange;
import java.util.Objects;

public class ResponseValidator {
    private final SchemaValidator schemaValidator;
    private final MessageResolver messages;

    public ResponseValidator(SchemaValidator schemaValidator, MessageResolver messages) {
        this.schemaValidator = Objects.requireNonNull(schemaValidator, "A schema validator is required");
        this.messages = Objects.requireNonNull(messages, "A message resolver is required");
    }

    public ValidationReport validateResponse(HttpServerExchange exchange, SwaggerOperation swaggerOperation) {
        Objects.requireNonNull(exchange, "An exchange is required");
        Objects.requireNonNull(swaggerOperation, "A swagger operation is required");
        Response swaggerResponse = (Response)swaggerOperation.getOperation().getResponses().get(Integer.toString(exchange.getStatusCode()));
        if (swaggerResponse == null) {
            swaggerResponse = (Response)swaggerOperation.getOperation().getResponses().get("default");
        }
        MutableValidationReport validationReport = new MutableValidationReport();
        if (swaggerResponse == null) {
            return validationReport.add(this.messages.get("validation.response.status.unknown", exchange.getStatusCode(), swaggerOperation.getPathString().original()));
        }
        if (swaggerResponse.getSchema() == null) {
            return validationReport;
        }
        String body = exchange.getOutputStream().toString();
        if (body == null || body.length() == 0) {
            return validationReport.add(this.messages.get("validation.response.body.missing", swaggerOperation.getMethod(), swaggerOperation.getPathString().original()));
        }
        return validationReport.merge(this.schemaValidator.validate(body, swaggerResponse.getSchema()));
    }
}

