/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.config.Config;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.utility.Util;
import com.networknt.validator.report.MessageResolver;
import com.networknt.validator.report.MutableValidationReport;
import com.networknt.validator.report.ValidationReport;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.util.Objects;
import java.util.Set;

public class SchemaValidator {
    private static final String ADDITIONAL_PROPERTIES_FIELD = "additionalProperties";
    private static final String DEFINITIONS_FIELD = "definitions";
    private final Swagger api;
    private JsonNode definitions;
    private final MessageResolver messages;

    public SchemaValidator(MessageResolver messages) {
        this(null, messages);
    }

    public SchemaValidator(Swagger api, MessageResolver messages) {
        this.api = api;
        this.messages = Objects.requireNonNull(messages, "A message resolver is required");
    }

    public ValidationReport validate(String value, Property schema) {
        return this.doValidate(value, schema);
    }

    public ValidationReport validate(String value, Model schema) {
        return this.doValidate(value, schema);
    }

    private ValidationReport doValidate(String value, Object schema) {
        Objects.requireNonNull(schema, "A schema is required");
        MutableValidationReport validationReport = new MutableValidationReport();
        Set processingReport = null;
        try {
            JsonNode schemaObject = Json.mapper().readTree(Json.pretty((Object)schema));
            if (this.api != null) {
                if (this.definitions == null) {
                    this.definitions = Json.mapper().readTree(Json.pretty((Object)this.api.getDefinitions()));
                }
                ((ObjectNode)schemaObject).set(DEFINITIONS_FIELD, this.definitions);
            }
            JsonSchema jsonSchema = new JsonSchemaFactory(Config.getInstance().getMapper()).getSchema(schemaObject);
            String normalisedValue = value;
            if (schema instanceof StringProperty) {
                normalisedValue = Util.quote((String)value);
            }
            JsonNode content = Json.mapper().readTree(normalisedValue);
            processingReport = jsonSchema.validate(content);
        }
        catch (JsonParseException e) {
            validationReport.add(this.messages.get("validation.schema.invalidJson", e.getMessage()));
            return validationReport;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (processingReport != null && processingReport.size() > 0) {
            processingReport.forEach(vm -> {
                String type = vm.getType();
                validationReport.add(this.messages.create("validation.schema." + type, vm.getMessage()));
            });
        }
        return validationReport;
    }
}

