/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator;

import com.networknt.config.Config;
import com.networknt.security.SwaggerHelper;
import com.networknt.validator.NormalisedPath;
import com.networknt.validator.RequestValidator;
import com.networknt.validator.ResponseValidator;
import com.networknt.validator.SchemaValidator;
import com.networknt.validator.SwaggerOperation;
import com.networknt.validator.ValidatorConfig;
import com.networknt.validator.report.MessageResolver;
import com.networknt.validator.report.MutableValidationReport;
import com.networknt.validator.report.ValidationReport;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorHandler
implements HttpHandler {
    public static final String CONFIG_NAME = "validator";
    public static final String ENABLE_VALIDATOR = "enableValidator";
    static final String ENABLE_RESPONSE_VALIDATOR = "enableResponseValidator";
    static final AttachmentKey<String> REQUEST_BODY = AttachmentKey.create(String.class);
    static final Logger logger = LoggerFactory.getLogger(ValidatorHandler.class);
    private final HttpHandler next;
    static final MessageResolver messages = new MessageResolver();
    RequestValidator requestValidator;
    ResponseValidator responseValidator;

    public ValidatorHandler(HttpHandler next) {
        MessageResolver messages = new MessageResolver();
        SchemaValidator schemaValidator = new SchemaValidator(SwaggerHelper.swagger, messages);
        this.requestValidator = new RequestValidator(schemaValidator, messages);
        this.responseValidator = new ResponseValidator(schemaValidator, messages);
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ValidatorConfig config = (ValidatorConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, ValidatorConfig.class);
        final MutableValidationReport validationReport = new MutableValidationReport();
        ApiBasedNormalisedPath requestPath = new ApiBasedNormalisedPath(exchange.getRequestURI());
        Optional<NormalisedPath> maybeApiPath = this.findMatchingApiPath(requestPath);
        if (!maybeApiPath.isPresent()) {
            validationReport.add(messages.get("validation.request.path.missing", exchange.getRequestURI()));
            exchange.setStatusCode(404);
            exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString((Object)validationReport));
            return;
        }
        NormalisedPath swaggerPathString = maybeApiPath.get();
        Path swaggerPath = SwaggerHelper.swagger.getPath(swaggerPathString.original());
        HttpMethod httpMethod = HttpMethod.valueOf((String)exchange.getRequestMethod().toString());
        Operation operation = (Operation)swaggerPath.getOperationMap().get(httpMethod);
        if (operation == null) {
            validationReport.add(messages.get("validation.request.operation.notAllowed", exchange.getRequestMethod(), swaggerPathString.original()));
            exchange.setStatusCode(405);
            exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString((Object)validationReport));
            return;
        }
        final SwaggerOperation swaggerOperation = new SwaggerOperation(swaggerPathString, swaggerPath, httpMethod, operation);
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        exchange.startBlocking();
        ValidationReport report = this.requestValidator.validateRequest(requestPath, exchange, swaggerOperation);
        validationReport.merge(report);
        if (validationReport.hasErrors()) {
            exchange.setStatusCode(400);
            exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString((Object)validationReport));
            return;
        }
        if (config.enableResponseValidator) {
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    validationReport.merge(ValidatorHandler.this.responseValidator.validateResponse(exchange, swaggerOperation));
                    if (validationReport.hasErrors()) {
                        logger.error("Response error" + validationReport);
                    }
                    nextListener.proceed();
                }
            });
        }
        this.next.handleRequest(exchange);
    }

    private Optional<NormalisedPath> findMatchingApiPath(NormalisedPath requestPath) {
        return SwaggerHelper.swagger.getPaths().keySet().stream().map(p -> new ApiBasedNormalisedPath((String)p)).filter(p -> this.pathMatches(requestPath, (NormalisedPath)p)).findFirst();
    }

    private boolean pathMatches(NormalisedPath requestPath, NormalisedPath apiPath) {
        if (requestPath.parts().size() != apiPath.parts().size()) {
            return false;
        }
        for (int i = 0; i < requestPath.parts().size(); ++i) {
            if (requestPath.part(i).equalsIgnoreCase(apiPath.part(i)) || apiPath.isParam(i)) continue;
            return false;
        }
        return true;
    }

    private class ApiBasedNormalisedPath
    implements NormalisedPath {
        private final List<String> pathParts;
        private final String original;
        private final String normalised;

        ApiBasedNormalisedPath(String path) {
            this.original = Objects.requireNonNull(path, "A path is required");
            this.normalised = this.normalise(path);
            this.pathParts = Collections.unmodifiableList(Arrays.asList(this.normalised.split("/")));
        }

        @Override
        public List<String> parts() {
            return this.pathParts;
        }

        @Override
        public String part(int index) {
            return this.pathParts.get(index);
        }

        @Override
        public boolean isParam(int index) {
            String part = this.part(index);
            return part.startsWith("{") && part.endsWith("}");
        }

        @Override
        public String paramName(int index) {
            if (!this.isParam(index)) {
                return null;
            }
            String part = this.part(index);
            return part.substring(1, part.length() - 1);
        }

        @Override
        public String original() {
            return this.original;
        }

        @Override
        public String normalised() {
            return this.normalised;
        }

        private String normalise(String requestPath) {
            if (SwaggerHelper.swagger.getBasePath() != null) {
                requestPath = requestPath.replace(SwaggerHelper.swagger.getBasePath(), "");
            }
            if (!requestPath.startsWith("/")) {
                return "/" + requestPath;
            }
            return requestPath;
        }
    }
}

