/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator.parameter;

import com.networknt.validator.SchemaValidator;
import com.networknt.validator.parameter.BaseParameterValidator;
import com.networknt.validator.report.MessageResolver;
import com.networknt.validator.report.MutableValidationReport;
import com.networknt.validator.report.ValidationReport;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.SerializableParameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;

public class ArrayParameterValidator
extends BaseParameterValidator {
    public static final String ARRAY_PARAMETER_TYPE = "array";
    private final SchemaValidator schemaValidator;

    public ArrayParameterValidator(SchemaValidator schemaValidator, MessageResolver messages) {
        super(messages);
        this.schemaValidator = schemaValidator == null ? new SchemaValidator(messages) : schemaValidator;
    }

    @Override
    public String supportedParameterType() {
        return ARRAY_PARAMETER_TYPE;
    }

    @Override
    public ValidationReport validate(String value, Parameter p) {
        MutableValidationReport report = new MutableValidationReport();
        if (!this.supports(p)) {
            return report;
        }
        SerializableParameter parameter = (SerializableParameter)p;
        if (parameter.getRequired() && (value == null || value.trim().isEmpty())) {
            return report.add(this.messages.get("validation.request.parameter.missing", parameter.getName()));
        }
        if (value == null || value.trim().isEmpty()) {
            return report;
        }
        this.doValidate(value, parameter, report);
        return report;
    }

    public ValidationReport validate(Collection<String> values, Parameter p) {
        MutableValidationReport report = new MutableValidationReport();
        if (p == null) {
            return report;
        }
        SerializableParameter parameter = (SerializableParameter)p;
        if (parameter.getRequired() && (values == null || values.isEmpty())) {
            return report.add(this.messages.get("validation.request.parameter.missing", parameter.getName()));
        }
        if (values == null) {
            return report;
        }
        if (!parameter.getCollectionFormat().equalsIgnoreCase(CollectionFormat.MULTI.name())) {
            return report.add(this.messages.get("validation.request.parameter.collection.invalidFormat", p.getName(), parameter.getCollectionFormat(), "multi"));
        }
        this.doValidate(values, parameter, report);
        return report;
    }

    @Override
    protected void doValidate(String value, SerializableParameter parameter, MutableValidationReport validationReport) {
        this.doValidate(CollectionFormat.from(parameter).split(value), parameter, validationReport);
    }

    private void doValidate(Collection<String> values, SerializableParameter parameter, MutableValidationReport validationReport) {
        if (parameter.getMaxItems() != null && values.size() > parameter.getMaxItems()) {
            validationReport.add(this.messages.get("validation.request.parameter.collection.tooManyItems", parameter.getName(), parameter.getMaxItems(), values.size()));
        }
        if (parameter.getMinItems() != null && values.size() < parameter.getMinItems()) {
            validationReport.add(this.messages.get("validation.request.parameter.collection.tooFewItems", parameter.getName(), parameter.getMinItems(), values.size()));
        }
        if (Boolean.TRUE.equals(parameter.isUniqueItems()) && values.stream().distinct().count() != (long)values.size()) {
            validationReport.add(this.messages.get("validation.request.parameter.collection.duplicateItems", parameter.getName()));
        }
        if (parameter.getEnum() != null && !parameter.getEnum().isEmpty()) {
            HashSet enumValues = new HashSet(parameter.getEnum());
            values.stream().filter(v -> !enumValues.contains(v)).forEach(v -> validationReport.add(this.messages.get("validation.request.parameter.enum.invalid", v, parameter.getName(), parameter.getEnum())));
            return;
        }
        values.forEach(v -> validationReport.addAll(this.schemaValidator.validate((String)v, parameter.getItems())));
    }

    private static enum CollectionFormat {
        CSV(","),
        SSV(" "),
        TSV("\t"),
        PIPES("\\|"),
        MULTI(null);

        final String separator;

        private CollectionFormat(String separator) {
            this.separator = separator;
        }

        Collection<String> split(String value) {
            if (this.separator == null) {
                return Collections.singleton(value);
            }
            return Arrays.asList(value.split(this.separator));
        }

        static CollectionFormat from(SerializableParameter parameter) {
            Objects.requireNonNull(parameter, "A parameter is required");
            return CollectionFormat.valueOf(parameter.getCollectionFormat().toUpperCase());
        }
    }
}

