/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator.parameter;

import com.networknt.validator.parameter.ParameterValidator;
import com.networknt.validator.report.MessageResolver;
import com.networknt.validator.report.MutableValidationReport;
import com.networknt.validator.report.ValidationReport;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.SerializableParameter;
import java.util.Objects;

abstract class BaseParameterValidator
implements ParameterValidator {
    protected final MessageResolver messages;

    protected BaseParameterValidator(MessageResolver messages) {
        this.messages = Objects.requireNonNull(messages, "A message resolver is required");
    }

    @Override
    public boolean supports(Parameter p) {
        return p != null && p instanceof SerializableParameter && this.supportedParameterType().equalsIgnoreCase(((SerializableParameter)p).getType());
    }

    @Override
    public ValidationReport validate(String value, Parameter p) {
        MutableValidationReport report = new MutableValidationReport();
        if (!this.supports(p)) {
            return report;
        }
        SerializableParameter parameter = (SerializableParameter)p;
        if (parameter.getRequired() && (value == null || value.trim().isEmpty())) {
            return report.add(this.messages.get("validation.request.parameter.missing", p.getName()));
        }
        if (value == null || value.trim().isEmpty()) {
            return report;
        }
        if (!this.matchesEnumIfDefined(value, parameter)) {
            return report.add(this.messages.get("validation.request.parameter.enum.invalid", value, parameter.getName(), parameter.getEnum()));
        }
        this.doValidate(value, parameter, report);
        return report;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesEnumIfDefined(String value, SerializableParameter parameter) {
        if (parameter.getEnum() == null) return true;
        if (parameter.getEnum().isEmpty()) return true;
        if (!parameter.getEnum().stream().anyMatch(value::equals)) return false;
        return true;
    }

    protected abstract void doValidate(String var1, SerializableParameter var2, MutableValidationReport var3);
}

