/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator.parameter;

import com.networknt.validator.parameter.BaseParameterValidator;
import com.networknt.validator.report.MessageResolver;
import com.networknt.validator.report.MutableValidationReport;
import io.swagger.models.parameters.SerializableParameter;

public class IntegerParameterValidator
extends BaseParameterValidator {
    public IntegerParameterValidator(MessageResolver messages) {
        super(messages);
    }

    @Override
    public String supportedParameterType() {
        return "integer";
    }

    @Override
    protected void doValidate(String value, SerializableParameter parameter, MutableValidationReport report) {
        if (parameter.getFormat().equalsIgnoreCase("int32")) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.failFormatValidation(value, parameter, "int32", report);
                return;
            }
        }
        if (parameter.getFormat().equalsIgnoreCase("int64")) {
            try {
                Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                this.failFormatValidation(value, parameter, "int64", report);
                return;
            }
        }
        Long d = Long.parseLong(value);
        if (parameter.getMinimum() != null && (double)d.longValue() < parameter.getMinimum()) {
            report.add(this.messages.get("validation.request.parameter.number.belowMin", value, parameter.getName(), parameter.getMinimum()));
        }
        if (parameter.getMaximum() != null && (double)d.longValue() > parameter.getMaximum()) {
            report.add(this.messages.get("validation.request.parameter.number.aboveMax", value, parameter.getName(), parameter.getMaximum()));
        }
    }

    private void failFormatValidation(String value, SerializableParameter parameter, String format, MutableValidationReport report) {
        report.add(this.messages.get("validation.request.parameter.invalidFormat", value, parameter.getName(), this.supportedParameterType(), format));
    }
}

