/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator.parameter;

import com.networknt.validator.parameter.BaseParameterValidator;
import com.networknt.validator.report.MessageResolver;
import com.networknt.validator.report.MutableValidationReport;
import io.swagger.models.parameters.SerializableParameter;

public class NumberParameterValidator
extends BaseParameterValidator {
    public NumberParameterValidator(MessageResolver messages) {
        super(messages);
    }

    @Override
    public String supportedParameterType() {
        return "number";
    }

    @Override
    protected void doValidate(String value, SerializableParameter parameter, MutableValidationReport report) {
        if (parameter.getFormat().equalsIgnoreCase("float")) {
            try {
                Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                this.failFormatValidation(value, parameter, "float", report);
                return;
            }
        }
        if (parameter.getFormat().equalsIgnoreCase("double")) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                this.failFormatValidation(value, parameter, "double", report);
                return;
            }
        }
        Double d = Double.parseDouble(value);
        if (parameter.getMinimum() != null && d < parameter.getMinimum()) {
            report.add(this.messages.get("validation.request.parameter.number.belowMin", value, parameter.getName(), parameter.getMinimum()));
        }
        if (parameter.getMaximum() != null && d > parameter.getMaximum()) {
            report.add(this.messages.get("validation.request.parameter.number.aboveMax", value, parameter.getName(), parameter.getMaximum()));
        }
    }

    private void failFormatValidation(String value, SerializableParameter parameter, String format, MutableValidationReport report) {
        report.add(this.messages.get("validation.request.parameter.invalidFormat", value, parameter.getName(), this.supportedParameterType(), format));
    }
}

