/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator.parameter;

import com.networknt.validator.SchemaValidator;
import com.networknt.validator.parameter.ArrayParameterValidator;
import com.networknt.validator.parameter.IntegerParameterValidator;
import com.networknt.validator.parameter.NumberParameterValidator;
import com.networknt.validator.parameter.ParameterValidator;
import com.networknt.validator.parameter.StringParameterValidator;
import com.networknt.validator.report.MessageResolver;
import com.networknt.validator.report.ValidationReport;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.SerializableParameter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class ParameterValidators {
    private final ArrayParameterValidator arrayValidator;
    private final MessageResolver messages;
    private final List<ParameterValidator> validators;

    public ParameterValidators(SchemaValidator schemaValidator, MessageResolver messages) {
        this.arrayValidator = new ArrayParameterValidator(schemaValidator, messages);
        this.messages = Objects.requireNonNull(messages);
        this.validators = Arrays.asList(new StringParameterValidator(messages), new NumberParameterValidator(messages), new IntegerParameterValidator(messages));
    }

    public ValidationReport validate(String value, Parameter parameter) {
        Objects.requireNonNull(parameter);
        if (parameter instanceof SerializableParameter && ((SerializableParameter)parameter).getType().equalsIgnoreCase("array")) {
            return this.arrayValidator.validate(value, parameter);
        }
        return this.validators.stream().filter(v -> v.supports(parameter)).map(v -> v.validate(value, parameter)).reduce(ValidationReport.empty(), ValidationReport::merge);
    }
}

