/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.validator.report;

import com.networknt.validator.report.MutableValidationReport;
import java.util.Collections;
import java.util.List;

public interface ValidationReport {
    public static final ValidationReport EMPTY_REPORT = new ValidationReport(){

        @Override
        public boolean hasErrors() {
            return false;
        }

        @Override
        public List<Message> getMessages() {
            return Collections.emptyList();
        }

        @Override
        public ValidationReport merge(ValidationReport other) {
            return other;
        }
    };

    public static ValidationReport empty() {
        return EMPTY_REPORT;
    }

    public static ValidationReport singleton(final Message message) {
        if (message == null) {
            return ValidationReport.empty();
        }
        return new ValidationReport(){

            @Override
            public boolean hasErrors() {
                return true;
            }

            @Override
            public List<Message> getMessages() {
                return Collections.singletonList(message);
            }

            @Override
            public ValidationReport merge(ValidationReport other) {
                MutableValidationReport result = new MutableValidationReport();
                result.addAll(this);
                result.addAll(other);
                return result;
            }
        };
    }

    default public boolean hasErrors() {
        return this.getMessages().size() > 0;
    }

    public List<Message> getMessages();

    public ValidationReport merge(ValidationReport var1);

    public static interface Message {
        public String getKey();

        public String getMessage();
    }
}

