/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.rule;

import com.networknt.rule.IAction;
import com.networknt.rule.Rule;
import com.networknt.rule.RuleAction;
import com.networknt.rule.RuleActionValue;
import com.networknt.rule.RuleEvaluator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEngine {
    private static final Logger logger = LoggerFactory.getLogger(RuleEngine.class);
    private final Map<String, Rule> ruleMap;
    private final Map<String, Collection<Rule>> groupMap;
    public final Map<String, IAction> actionClassCache = new ConcurrentHashMap<String, IAction>();

    public RuleEngine(Map<String, Rule> ruleMap, Map<String, Collection<Rule>> groupMap) {
        this.ruleMap = ruleMap;
        this.groupMap = groupMap;
    }

    public Map executeRules(String groupId, Map<String, Object> objMap) throws Exception {
        Collection<Rule> rules = this.groupMap.get(groupId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (rules != null && rules.size() > 0) {
            try {
                for (Rule rule : rules) {
                    RuleEvaluator evaluator = RuleEvaluator.getInstance();
                    boolean result = evaluator.evaluate(rule, objMap, resultMap);
                    resultMap.put("result", result);
                    if (!result) continue;
                    for (RuleAction ra : rule.getActions()) {
                        String actionType = ra.getActionClassName();
                        Collection<RuleActionValue> ravs = ra.getActionValues();
                        IAction ia = this.actionClassCache.get(actionType);
                        if (ia == null) {
                            ia = (IAction)Class.forName(actionType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            this.actionClassCache.put(actionType, ia);
                        }
                        ia.performAction(objMap, resultMap, ravs);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Rule Engine Runtime Exception", (Throwable)e);
                resultMap.put("RuleEngineException", e);
            }
        } else {
            logger.error("Rule group cannot be found with groupId = " + groupId);
            resultMap.put("RuleEngineException", "Rule group not found for " + groupId);
        }
        return resultMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map executeRule(String ruleId, Map<String, Object> objMap) throws Exception {
        Rule rule = this.ruleMap.get(ruleId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (rule != null) {
            try {
                Collection<RuleAction> actions;
                RuleEvaluator evaluator = RuleEvaluator.getInstance();
                boolean result = evaluator.evaluate(rule, objMap, resultMap);
                if (logger.isDebugEnabled()) {
                    logger.debug("executeRule result = " + result);
                }
                resultMap.put("result", result);
                if (!result || (actions = rule.getActions()) == null) return resultMap;
                for (RuleAction ra : actions) {
                    String actionType = ra.getActionClassName();
                    Collection<RuleActionValue> ravs = ra.getActionValues();
                    IAction ia = this.actionClassCache.get(actionType);
                    if (ia == null) {
                        ia = (IAction)Class.forName(actionType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.actionClassCache.put(actionType, ia);
                    }
                    ia.performAction(objMap, resultMap, ravs);
                }
                return resultMap;
            }
            catch (Exception e) {
                logger.error("Rule Engine Runtime Exception", (Throwable)e);
                resultMap.put("RuleEngineException", e);
                return resultMap;
            }
        } else {
            logger.error("Rule cannot be found with id = " + ruleId);
            resultMap.put("RuleEngineException", "Rule not found for " + ruleId);
        }
        return resultMap;
    }
}

