/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.rule;

import com.networknt.rule.Rule;
import com.networknt.rule.RuleCondition;
import com.networknt.rule.RuleConditionValue;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEvaluator {
    private static RuleEvaluator instance = null;
    private static Logger logger = LoggerFactory.getLogger(RuleEvaluator.class);
    private static Map accessorMap = new HashMap();
    private static final Class[] EMPTY_CLASS_LIST = new Class[0];
    private static final String ACCESSOR_METHOD_PREFIX = "get";
    private static HashSet simpleTypes = new HashSet();

    private RuleEvaluator() {
    }

    public static synchronized RuleEvaluator getInstance() {
        if (instance == null) {
            instance = new RuleEvaluator();
        }
        return instance;
    }

    public boolean evaluate(Rule rule, Map objMap, Map resultMap) throws Exception {
        boolean result = true;
        Collection<RuleCondition> conditions = rule.getConditions();
        if (conditions != null && !conditions.isEmpty()) {
            for (RuleCondition rc : conditions) {
                boolean r = this.evaluateCondition(rc.getPropertyPath(), rc.getOperatorCode(), (List)rc.getConditionValues(), objMap);
                resultMap.put(rc.getConditionId(), r);
                result = this.evaluateJoin(rc.getJoinCode(), result, r);
            }
        }
        return result;
    }

    private boolean evaluateJoin(String opCode, boolean cr1Result, boolean cr2Result) throws Exception {
        if ("AND".equals(opCode)) {
            return cr1Result && cr2Result;
        }
        if ("OR".equals(opCode)) {
            return cr1Result || cr2Result;
        }
        if ("NOT".equals(opCode)) {
            return cr1Result && !cr2Result;
        }
        logger.error("Condition join operator " + opCode + " is not supported");
        throw new Exception("Condition join operator " + opCode + " is not supported");
    }

    private boolean evaluateCondition(String propertyPath, String opCode, List conditionValues, Object object) throws Exception {
        if (object == null) {
            logger.warn("Input object is null for operator " + opCode);
            throw new Exception("Input object is null for operator " + opCode);
        }
        Object valueObject = null;
        if (conditionValues != null && !conditionValues.isEmpty()) {
            RuleConditionValue conditionValue = (RuleConditionValue)conditionValues.get(0);
            valueObject = conditionValue.isExpression() ? this.getObjectByPath(conditionValue.getConditionValue(), object) : conditionValue.getConditionValue();
        }
        if ("EQ".equals(opCode)) {
            return this.evaluateEquals(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("NEQ".equals(opCode)) {
            return !this.evaluateEquals(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("CS".equals(opCode)) {
            return this.evaluateContains(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("NCS".equals(opCode)) {
            return !this.evaluateContains(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("IN".equals(opCode)) {
            return this.evaluateInList(this.getObjectByPath(propertyPath, object), conditionValues);
        }
        if ("NIN".equals(opCode)) {
            return !this.evaluateInList(this.getObjectByPath(propertyPath, object), conditionValues);
        }
        if ("GT".equals(opCode)) {
            return this.evaluateGreaterThan(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("LT".equals(opCode)) {
            return this.evaluateLessThan(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("NIL".equals(opCode)) {
            return this.isEmpty(this.getObjectByPath(propertyPath, object));
        }
        if ("NNIL".equals(opCode)) {
            return !this.isEmpty(this.getObjectByPath(propertyPath, object));
        }
        if ("BF".equals(opCode)) {
            return this.evaluateBefore(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("AF".equals(opCode)) {
            return this.evaluateAfter(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("LEN_EQ".equals(opCode)) {
            return this.evaluateLenEq(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("LEN_GT".equals(opCode)) {
            return this.evaluateLenGt(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("LEN_LT".equals(opCode)) {
            return this.evaluateLenLt(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("MATCH".equals(opCode)) {
            return this.evaluateMatch(this.getObjectByPath(propertyPath, object), valueObject);
        }
        if ("NMATCH".equals(opCode)) {
            return !this.evaluateMatch(this.getObjectByPath(propertyPath, object), valueObject);
        }
        logger.warn("Operator " + opCode + " is not supported");
        throw new Exception("Invalid operator" + opCode);
    }

    public Object getObjectByPath(String propertyPath, Object object) {
        String subProperty;
        if (object == null) {
            return null;
        }
        if (propertyPath == null) {
            return object;
        }
        boolean isLastProp = true;
        int index = propertyPath.indexOf(".");
        if (index > 0) {
            isLastProp = false;
            subProperty = propertyPath.substring(0, index);
        } else {
            subProperty = propertyPath;
        }
        if (object instanceof Map) {
            Object o = ((Map)object).get(subProperty);
            if (isLastProp) {
                return o;
            }
            return this.getObjectByPath(propertyPath.substring(subProperty.length() + 1), o);
        }
        if (object instanceof List) {
            Object o = ((List)object).get(Integer.valueOf(subProperty));
        } else {
            Class<?> clazz = object.getClass();
            Method[] accessors = this.getAccessors(clazz);
            for (int i = 0; i < accessors.length; ++i) {
                if (!accessors[i].getName().substring(ACCESSOR_METHOD_PREFIX.length()).equals(subProperty)) continue;
                try {
                    Object o = accessors[i].invoke(object, (Object[])EMPTY_CLASS_LIST);
                    if (isLastProp) {
                        return o;
                    }
                    return this.getObjectByPath(propertyPath.substring(subProperty.length() + 1), o);
                }
                catch (Exception e) {
                    logger.error("invoke error", (Throwable)e);
                }
            }
        }
        return null;
    }

    private boolean evaluateEquals(Object object, Object valueObject) throws Exception {
        if (object == null || valueObject == null) {
            return object == null && valueObject == null;
        }
        if (valueObject instanceof String) {
            Object convertedValueObject = this.convertConditionValue(object, (String)valueObject);
            return object.equals(convertedValueObject);
        }
        return object.equals(valueObject);
    }

    private boolean evaluateContains(Object object, Object valueObject) throws Exception {
        if (object == null || valueObject == null) {
            return object == null && valueObject == null;
        }
        if (valueObject instanceof String) {
            return object.toString().indexOf((String)valueObject) >= 0;
        }
        logger.error("Contains evaluation with type different than string " + object.getClass());
        return false;
    }

    private boolean evaluateInList(Object object, List valueConditions) throws Exception {
        if (object == null || valueConditions == null || valueConditions.isEmpty()) {
            return object == null && (valueConditions == null || valueConditions.isEmpty());
        }
        boolean match = false;
        ListIterator it = valueConditions.listIterator();
        while (!match && it.hasNext()) {
            RuleConditionValue value = (RuleConditionValue)it.next();
            Object valueObject = this.convertConditionValue(object, value.getConditionValue());
            if (object == null || valueObject == null) {
                match = object == null && valueObject == null;
                continue;
            }
            match = object.equals(valueObject);
        }
        return match;
    }

    private boolean evaluateGreaterThan(Object object, Object valueObject) throws Exception {
        boolean result = this.compareNumeric(object, valueObject) > 0;
        return result;
    }

    private boolean evaluateLessThan(Object object, Object valueObject) throws Exception {
        boolean result = this.compareNumeric(object, valueObject) < 0;
        return result;
    }

    private int compareNumeric(Object object, Object valueObject) throws Exception {
        if (!(object instanceof Number)) {
            throw new Exception("Object is not a number:" + object.getClass());
        }
        if (this.evaluateEquals(object, valueObject)) {
            return 0;
        }
        if (object == null && valueObject == null) {
            return 0;
        }
        if (object == null && valueObject != null) {
            return -1;
        }
        if (object != null && valueObject == null) {
            return 1;
        }
        Object value = valueObject;
        if (valueObject instanceof String) {
            value = this.convertConditionValue(object, (String)valueObject);
        }
        if (value == null && object == null) {
            return 0;
        }
        if (value != null && object == null) {
            return -1;
        }
        if (value == null && object != null) {
            return 1;
        }
        if (object.getClass().getName().equals("java.lang.Integer")) {
            return ((Integer)object).compareTo((Integer)value);
        }
        if (object.getClass().getName().equals("java.math.BigDecimal")) {
            return ((BigDecimal)object).compareTo((BigDecimal)value);
        }
        if (object.getClass().getName().equals("java.lang.Long")) {
            return ((Long)object).compareTo((Long)value);
        }
        if (object.getClass().getName().equals("java.math.BigInteger")) {
            return ((BigInteger)object).compareTo((BigInteger)value);
        }
        if (object.getClass().getName().equals("java.lang.Byte")) {
            return ((Byte)object).compareTo((Byte)value);
        }
        if (object.getClass().getName().equals("java.lang.Double")) {
            return ((Double)object).compareTo((Double)value);
        }
        if (object.getClass().getName().equals("java.lang.Float")) {
            return ((Float)object).compareTo((Float)value);
        }
        if (object.getClass().getName().equals("java.lang.Short")) {
            return ((Short)object).compareTo((Short)value);
        }
        return 0;
    }

    private boolean evaluateBefore(Object object, Object valueObject) throws Exception {
        boolean result = this.compareDate(object, valueObject) < 0;
        return result;
    }

    private boolean evaluateAfter(Object object, Object valueObject) throws Exception {
        boolean result = this.compareDate(object, valueObject) > 0;
        return result;
    }

    private int compareDate(Object object, Object valueObject) throws Exception {
        if (!(object instanceof java.util.Date)) {
            throw new Exception("Object is not a Date");
        }
        if (this.evaluateEquals(object, valueObject)) {
            return 0;
        }
        if (object == null && valueObject == null) {
            return 0;
        }
        if (object == null && valueObject != null) {
            return -1;
        }
        if (object != null && valueObject == null) {
            return 1;
        }
        Object value = valueObject;
        if (valueObject instanceof String) {
            value = this.convertConditionValue(object, (String)valueObject);
        }
        if (value == null && object == null) {
            return 0;
        }
        if (value != null && object == null) {
            return -1;
        }
        if (value == null && object != null) {
            return 1;
        }
        if (object.getClass().getName().equals("java.util.Date")) {
            return ((java.util.Date)object).compareTo((java.util.Date)value);
        }
        if (object.getClass().getName().equals("java.sql.Date")) {
            return ((Date)object).compareTo((java.util.Date)value);
        }
        if (object.getClass().getName().equals("java.sql.Timestamp")) {
            return ((Timestamp)object).compareTo((Timestamp)value);
        }
        return 0;
    }

    private boolean evaluateLenEq(Object object, Object valueObject) throws Exception {
        return this.compareStringLength(object, valueObject) == 0;
    }

    private boolean evaluateLenGt(Object object, Object valueObject) throws Exception {
        return this.compareStringLength(object, valueObject) > 0;
    }

    private boolean evaluateLenLt(Object object, Object valueObject) throws Exception {
        return this.compareStringLength(object, valueObject) < 0;
    }

    private int compareStringLength(Object object, Object valueObject) throws Exception {
        if (!(object instanceof String)) {
            throw new Exception("Object is not a String:" + object.getClass());
        }
        if (this.evaluateEquals(object, valueObject)) {
            return 0;
        }
        if (object == null && valueObject == null) {
            return 0;
        }
        if (object == null && valueObject != null) {
            return -1;
        }
        if (object != null && valueObject == null) {
            return 1;
        }
        if (valueObject == null && object == null) {
            return 0;
        }
        if (valueObject != null && object == null) {
            return -1;
        }
        if (valueObject == null && object != null) {
            return 1;
        }
        Object value = valueObject;
        if (!(valueObject instanceof String)) {
            value = valueObject.toString();
        }
        if (object.getClass().getName().equals("java.lang.String")) {
            return ((String)object).length() - ((String)value).length();
        }
        throw new Exception("Incompatible object to compare length of String with " + object.getClass().getName());
    }

    private boolean evaluateMatch(Object object, Object valueObject) throws Exception {
        if (!(object instanceof String)) {
            throw new Exception("Object is not a String:" + object.getClass());
        }
        Object value = valueObject;
        if (!(valueObject instanceof String)) {
            value = valueObject.toString();
        }
        if (value != null && ((String)value).length() > 0) {
            return Pattern.matches((String)value, (String)object);
        }
        throw new Exception("Condition Value is empty");
    }

    private boolean isEmpty(Object val) {
        return val == null || val.toString().trim().length() == 0;
    }

    private Object convertConditionValue(Object object, String valueStr) throws Exception {
        Class<?> clazz = object.getClass();
        Object oret = null;
        if (clazz.getName().equals("java.lang.String")) {
            oret = valueStr;
        }
        if (clazz.getName().equals("java.lang.Integer")) {
            oret = Integer.valueOf(valueStr);
        }
        if (clazz.getName().equals("java.math.BigDecimal")) {
            oret = new BigDecimal(valueStr);
        }
        if (clazz.getName().equals("java.math.BigInteger")) {
            oret = new BigInteger(valueStr);
        }
        if (clazz.getName().equals("java.lang.Long")) {
            oret = Long.valueOf(valueStr);
        }
        if (clazz.getName().equals("java.lang.Boolean")) {
            oret = new Boolean(valueStr);
        }
        if (clazz.getName().equals("java.lang.Byte")) {
            oret = Byte.valueOf(valueStr);
        }
        if (clazz.getName().equals("java.lang.Character")) {
            oret = new Character(valueStr.charAt(0));
        }
        if (clazz.getName().equals("java.lang.Double")) {
            oret = new Double(valueStr);
        }
        if (clazz.getName().equals("java.lang.Float")) {
            oret = new Float(valueStr);
        }
        if (clazz.getName().equals("java.lang.Short")) {
            oret = new Short(valueStr);
        }
        if (clazz.getName().equals("java.sql.Timestamp")) {
            oret = Timestamp.valueOf(valueStr);
        }
        if (clazz.getName().equals("java.util.Date")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            oret = df.parse(valueStr);
        }
        if (clazz.getName().equals("java.sql.Date")) {
            oret = Date.valueOf(valueStr);
        }
        return oret;
    }

    private Method[] getAccessors(Class clazz) {
        Method[] allMethods = (Method[])accessorMap.get(clazz);
        if (allMethods == null) {
            allMethods = clazz.getMethods();
            ArrayList<Method> accessors = new ArrayList<Method>(allMethods.length);
            for (int i = 0; i < allMethods.length; ++i) {
                allMethods[i].setAccessible(true);
                if (!allMethods[i].getName().startsWith(ACCESSOR_METHOD_PREFIX) || allMethods[i].getParameterTypes().length != 0) continue;
                accessors.add(allMethods[i]);
            }
            allMethods = accessors.toArray(new Method[accessors.size()]);
            accessorMap.put(clazz, allMethods);
        }
        return allMethods;
    }

    static {
        simpleTypes.add("java.lang.String");
        simpleTypes.add("java.lang.Integer");
        simpleTypes.add("java.math.BigDecimal");
        simpleTypes.add("java.math.BigInteger");
        simpleTypes.add("java.lang.Long");
        simpleTypes.add("java.lang.Boolean");
        simpleTypes.add("java.lang.Byte");
        simpleTypes.add("java.lang.Character");
        simpleTypes.add("java.lang.Double");
        simpleTypes.add("java.lang.Float");
        simpleTypes.add("java.lang.Short");
        simpleTypes.add("java.sql.Timestamp");
    }
}

