/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.rule;

import com.networknt.rule.IAction;
import com.networknt.rule.Rule;
import com.networknt.rule.RuleAction;
import com.networknt.rule.RuleActionValue;
import com.networknt.rule.RuleEvaluator;
import com.networknt.rule.custom.CustomOperator;
import com.networknt.rule.exception.ActionExecutionException;
import com.networknt.rule.exception.RuleEngineException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEngine {
    private static final Logger logger = LoggerFactory.getLogger(RuleEngine.class);
    private final Map<String, Rule> ruleMap;
    private final Map<String, Collection<Rule>> groupMap;
    public final Map<String, IAction> actionClassCache = new ConcurrentHashMap<String, IAction>();

    public RuleEngine(Map<String, Rule> ruleMap, Map<String, Collection<Rule>> groupMap) {
        this.ruleMap = ruleMap;
        this.groupMap = groupMap;
    }

    public Map<String, Object> executeRules(String groupId, Map<String, Object> objMap) throws RuleEngineException {
        Collection<Rule> rules = this.groupMap.get(groupId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (rules != null && !rules.isEmpty()) {
            try {
                for (Rule rule : rules) {
                    RuleEvaluator evaluator = RuleEvaluator.getInstance();
                    boolean result = evaluator.evaluate(rule, objMap, resultMap);
                    resultMap.put("result", result);
                    Collection<RuleAction> actions = rule.getActions();
                    this.handleActions(rule.getRuleId(), result, actions, objMap, resultMap);
                }
            }
            catch (RuleEngineException e) {
                logger.error("Error executing rules in group {}: {}", new Object[]{groupId, e.getMessage(), e});
                resultMap.put("RuleEngineException", e);
                throw e;
            }
        } else {
            String errorMsg = "Rule group cannot be found with groupId " + groupId;
            logger.error("Error executing rule group in group {}: {}", (Object)groupId, (Object)errorMsg);
            resultMap.put("RuleEngineException", "Rule group not found for " + groupId);
            throw new RuleEngineException(errorMsg, groupId);
        }
        return resultMap;
    }

    private void handleActions(String ruleId, boolean result, Collection<RuleAction> actions, Map<String, Object> objMap, Map<String, Object> resultMap) throws RuleEngineException {
        block6: {
            block7: {
                RuleAction ra;
                block8: {
                    if (actions == null) break block6;
                    if (actions.size() != 1) break block7;
                    ra = actions.iterator().next();
                    if (!result) break block8;
                    if (logger.isTraceEnabled()) {
                        logger.trace("Single action and evaluation is true, execute action  {}.", (Object)ra.getActionId());
                    }
                    this.performAction(ruleId, ra, objMap, resultMap);
                    break block6;
                }
                if (!logger.isTraceEnabled()) break block6;
                logger.trace("Single action and evaluation is false, skip action {}.", (Object)ra.getActionId());
                break block6;
            }
            for (RuleAction ra : actions) {
                if (ra.isConditionResult() == null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Multiple actions evaluation {}, conditionResult is {}, execute action {} regardless.", new Object[]{result, ra.isConditionResult(), ra.getActionId()});
                    }
                    this.performAction(ruleId, ra, objMap, resultMap);
                    continue;
                }
                if (ra.isConditionResult() == result) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Multiple actions evaluation is {}, conditionResult is {}, execute action {}.", new Object[]{result, ra.isConditionResult(), ra.getActionId()});
                    }
                    this.performAction(ruleId, ra, objMap, resultMap);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Multiple actions evaluation is {}, conditionResult is {}, skip action {}.", new Object[]{result, ra.isConditionResult(), ra.getActionId()});
            }
        }
    }

    private void performAction(String ruleId, RuleAction ra, Map<String, Object> objMap, Map<String, Object> resultMap) throws RuleEngineException {
        String actionType = ra.getActionClassName();
        Collection<RuleActionValue> actionValues = ra.getActionValues();
        IAction ia = this.actionClassCache.get(actionType);
        if (ia == null) {
            try {
                ia = (IAction)Class.forName(actionType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                String errorMsg = "IAction class " + actionType + " not found";
                logger.error("Error executing action in rule {}, action {}: {}", new Object[]{ruleId, ra.getActionId(), errorMsg, e});
                throw new ActionExecutionException(errorMsg, ruleId, ra.getActionId());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                String errorMsg = "IAction class " + actionType + " cannot be initialized";
                logger.error("Error executing action in rule {}, action {}: {}", new Object[]{ruleId, ra.getActionId(), errorMsg, e});
                throw new ActionExecutionException(errorMsg, ruleId, ra.getActionId());
            }
            this.actionClassCache.put(actionType, ia);
        }
        if (actionValues != null) {
            for (RuleActionValue actionValue : actionValues) {
                actionValue.setResolvedValue(RuleEvaluator.getInstance().resolveVariable(actionValue.getValue(), objMap, resultMap));
            }
        }
        ia.performAction(ruleId, ra.getActionId(), objMap, resultMap, actionValues);
        ia.postPerformAction(ruleId, ra.getActionId(), objMap, resultMap, actionValues);
    }

    public Map<String, Object> executeRule(String ruleId, Map<String, Object> objMap) throws RuleEngineException {
        Rule rule = this.ruleMap.get(ruleId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (rule != null) {
            try {
                RuleEvaluator evaluator = RuleEvaluator.getInstance();
                boolean result = evaluator.evaluate(rule, objMap, resultMap);
                if (logger.isDebugEnabled()) {
                    logger.debug("executeRule result = {}", (Object)result);
                }
                resultMap.put("result", result);
                Collection<RuleAction> actions = rule.getActions();
                this.handleActions(ruleId, result, actions, objMap, resultMap);
            }
            catch (RuleEngineException e) {
                logger.error("Error executing rule in rule {}: {}", new Object[]{ruleId, e.getMessage(), e});
                resultMap.put("RuleEngineException", e.getMessage());
                throw e;
            }
        } else {
            String errorMsg = "Rule cannot be found with id " + ruleId;
            logger.error("Error executing rule in rule {}: {}", (Object)ruleId, (Object)errorMsg);
            resultMap.put("RuleEngineException", "Rule not found for " + ruleId);
            throw new RuleEngineException(errorMsg, ruleId);
        }
        return resultMap;
    }

    public void registerCustomOperator(String operatorName, CustomOperator operator) {
        RuleEvaluator.customOperatorRegistry.put(operatorName, operator);
    }

    public CustomOperator getCustomOperator(String operatorName) {
        return RuleEvaluator.customOperatorRegistry.get(operatorName);
    }
}

