/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.rule;

import com.networknt.rule.LogicalOperator;
import com.networknt.rule.Rule;
import com.networknt.rule.RuleCondition;
import com.networknt.rule.RuleConditionValue;
import com.networknt.rule.RuleOperator;
import com.networknt.rule.custom.ContainsIgnoreCaseOperator;
import com.networknt.rule.custom.CustomOperator;
import com.networknt.rule.custom.StartsWithOperator;
import com.networknt.rule.exception.ConditionEvaluationException;
import com.networknt.rule.exception.InvalidOperatorException;
import com.networknt.rule.exception.RuleEngineException;
import com.networknt.rule.operation.BigDecimalTypeOperation;
import com.networknt.rule.operation.BigIntegerTypeOperation;
import com.networknt.rule.operation.ByteTypeOperation;
import com.networknt.rule.operation.DateTypeOperation;
import com.networknt.rule.operation.DoubleTypeOperation;
import com.networknt.rule.operation.FloatTypeOperation;
import com.networknt.rule.operation.IntegerTypeOperation;
import com.networknt.rule.operation.LongTypeOperation;
import com.networknt.rule.operation.ShortTypeOperation;
import com.networknt.rule.operation.StringTypeOperation;
import com.networknt.rule.operation.TypeSpecificOperation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEvaluator {
    private static RuleEvaluator instance = null;
    private static final Logger logger = LoggerFactory.getLogger(RuleEvaluator.class);
    private static final Logger traceLogger = LoggerFactory.getLogger((String)"rule.trace");
    private static final Map accessorMap = new HashMap();
    private static final Class[] EMPTY_CLASS_LIST = new Class[0];
    private static HashSet simpleTypes;
    private static final ThreadLocal<Map<String, Object>> objectCache;
    private final Map<String, Pattern> patternCache = new ConcurrentHashMap<String, Pattern>();
    private final Map<Class<?>, TypeSpecificOperation<?>> typeStrategies = new HashMap();
    protected static final Map<String, CustomOperator> customOperatorRegistry;

    private RuleEvaluator() {
        this.typeStrategies.put(Integer.class, new IntegerTypeOperation());
        this.typeStrategies.put(BigDecimal.class, new BigDecimalTypeOperation());
        this.typeStrategies.put(Long.class, new LongTypeOperation());
        this.typeStrategies.put(BigInteger.class, new BigIntegerTypeOperation());
        this.typeStrategies.put(Byte.class, new ByteTypeOperation());
        this.typeStrategies.put(Double.class, new DoubleTypeOperation());
        this.typeStrategies.put(Float.class, new FloatTypeOperation());
        this.typeStrategies.put(Short.class, new ShortTypeOperation());
        this.typeStrategies.put(String.class, new StringTypeOperation());
        this.typeStrategies.put(java.util.Date.class, new DateTypeOperation());
        this.typeStrategies.put(Date.class, new DateTypeOperation());
        this.typeStrategies.put(Timestamp.class, new DateTypeOperation());
        customOperatorRegistry.put("containsIgnoreCase", new ContainsIgnoreCaseOperator());
        customOperatorRegistry.put("startsWith", new StartsWithOperator());
    }

    public static synchronized RuleEvaluator getInstance() {
        if (instance == null) {
            instance = new RuleEvaluator();
        }
        return instance;
    }

    public boolean evaluate(Rule rule, Map objMap, Map resultMap) throws RuleEngineException {
        boolean result;
        objectCache.get().clear();
        if (rule.getConditions() == null || rule.getConditions().isEmpty()) {
            return true;
        }
        if (rule.getConditionExpression() != null && !rule.getConditionExpression().trim().isEmpty()) {
            result = this.evaluateConditionExpression(rule.getRuleId(), rule.getConditionExpression(), rule.getConditions(), objMap, resultMap);
        } else {
            result = true;
            for (RuleCondition rc : rule.getConditions()) {
                boolean r = this.evaluateCondition(rule.getRuleId(), rc.getConditionId(), rc.getPropertyPath(), rc.getOperatorCode(), (List)rc.getConditionValues(), objMap);
                resultMap.put(rc.getConditionId(), r);
                if (r) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    boolean evaluateConditionExpression(String ruleId, String expression, Collection<RuleCondition> conditions, Map objMap, Map resultMap) throws RuleEngineException {
        traceLogger.debug("Evaluating expression: {} for rule: {}", (Object)expression, (Object)ruleId);
        Stack<Boolean> stack = new Stack<Boolean>();
        Stack<String> operatorStack = new Stack<String>();
        StringTokenizer tokenizer = new StringTokenizer(expression, "() ", true);
        while (tokenizer.hasMoreTokens()) {
            boolean conditionResult;
            String token = tokenizer.nextToken().trim();
            if (token.isEmpty()) continue;
            traceLogger.debug("Evaluating expression: {}, token: {}", (Object)expression, (Object)token);
            if (token.equals("(")) {
                operatorStack.push(token);
                traceLogger.debug("Pushing opening parenthesis to the stack: {}, operator stack size: {}", (Object)token, (Object)operatorStack.size());
                continue;
            }
            if (token.equals(")")) {
                while (!operatorStack.isEmpty() && !operatorStack.peek().equals("(")) {
                    this.processOperator(ruleId, stack, operatorStack, objMap, resultMap, conditions);
                }
                if (operatorStack.isEmpty() || !operatorStack.peek().equals("(")) continue;
                operatorStack.pop();
                traceLogger.debug("Popping opening parenthesis from the stack, operator stack size: {}", (Object)operatorStack.size());
                continue;
            }
            LogicalOperator logicalOperator = null;
            try {
                logicalOperator = LogicalOperator.fromString(token);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (logicalOperator == LogicalOperator.AND || logicalOperator == LogicalOperator.OR) {
                while (!operatorStack.isEmpty() && !operatorStack.peek().equals("(") && this.hasHigherPrecedence(operatorStack.peek(), token)) {
                    this.processOperator(ruleId, stack, operatorStack, objMap, resultMap, conditions);
                }
                operatorStack.push(token);
                traceLogger.debug("Pushing operator to the stack: {}, operator stack size: {}", (Object)token, (Object)operatorStack.size());
                continue;
            }
            if (resultMap.containsKey(token)) {
                conditionResult = (Boolean)resultMap.get(token);
            } else {
                RuleCondition ruleCondition = this.getRuleCondition(token, conditions);
                if (ruleCondition == null) {
                    String errorMsg = "Condition with id: " + token + " is not defined";
                    logger.error("Error evaluating condition in rule {} missing condition {}: {}", new Object[]{ruleId, token, errorMsg});
                    throw new RuleEngineException(errorMsg, ruleId);
                }
                conditionResult = this.evaluateCondition(ruleId, ruleCondition.getConditionId(), ruleCondition.getPropertyPath(), ruleCondition.getOperatorCode(), (List)ruleCondition.getConditionValues(), objMap);
                resultMap.put(token, conditionResult);
            }
            traceLogger.debug("Pushing condition result to the stack: {}, for conditionId: {}, stack size: {}", new Object[]{conditionResult, token, stack.size() + 1});
            stack.push(conditionResult);
        }
        while (!operatorStack.isEmpty()) {
            this.processOperator(ruleId, stack, operatorStack, objMap, resultMap, conditions);
        }
        if (stack.size() != 1) {
            String errorMsg = "Invalid expression " + expression + ". Stack size " + stack + " 1";
            logger.error("Error evaluating condition in rule {}, expression {}: {}", new Object[]{ruleId, expression, errorMsg});
            throw new RuleEngineException(errorMsg, ruleId);
        }
        boolean result = (Boolean)stack.pop();
        traceLogger.debug("Result for the expression: {} is: {}", (Object)expression, (Object)result);
        return result;
    }

    private boolean hasHigherPrecedence(String op1, String op2) {
        if (op1.equals("(") || op1.equals(")")) {
            return false;
        }
        if (op2.equals("(") || op2.equals(")")) {
            return true;
        }
        return LogicalOperator.fromString(op1) == LogicalOperator.AND && LogicalOperator.fromString(op2) == LogicalOperator.OR;
    }

    private void processOperator(String ruleId, Stack<Boolean> stack, Stack<String> operatorStack, Map objMap, Map resultMap, Collection<RuleCondition> conditions) throws RuleEngineException {
        String operator = operatorStack.pop();
        traceLogger.debug("Processing operator: {}, operator stack size: {}", (Object)operator, (Object)operatorStack.size());
        if (LogicalOperator.fromString(operator) == LogicalOperator.AND || LogicalOperator.fromString(operator) == LogicalOperator.OR) {
            if (stack.size() < 2) {
                String errorMsg = "Invalid expression. Stack size " + stack.size() + " is less than 2 for an operator " + operator;
                logger.error("Error evaluating condition in rule {}: {}", (Object)ruleId, (Object)errorMsg);
                throw new RuleEngineException(errorMsg, ruleId);
            }
            boolean operand2 = stack.pop();
            boolean operand1 = stack.pop();
            traceLogger.debug("popped two operands: {} and {} from the stack. stack size: {}. ", new Object[]{operand1, operand2, stack.size()});
            boolean result = false;
            if (LogicalOperator.fromString(operator) == LogicalOperator.AND) {
                result = operand1 && operand2;
            } else if (LogicalOperator.fromString(operator) == LogicalOperator.OR) {
                result = operand1 || operand2;
            }
            traceLogger.debug("Result of operator {}: {} is: {} and push the result to the stack.", new Object[]{operator, operand1 + " " + operator + " " + operand2, result});
            stack.push(result);
        }
    }

    private RuleCondition getRuleCondition(String conditionId, Collection<RuleCondition> conditions) {
        for (RuleCondition condition : conditions) {
            if (!condition.getConditionId().equals(conditionId)) continue;
            return condition;
        }
        return null;
    }

    protected boolean evaluateCondition(String ruleId, String conditionId, String propertyPath, String opCode, List<RuleConditionValue> conditionValues, Object object) throws RuleEngineException {
        if (object == null) {
            String errorMsg = "Input object is null for operator " + opCode;
            logger.error("Error evaluating condition in rule {}, condition {}: {}", new Object[]{ruleId, conditionId, errorMsg});
            throw new ConditionEvaluationException(errorMsg, ruleId, conditionId);
        }
        Object valueObject = null;
        RuleConditionValue conditionValue = null;
        if (conditionValues != null && !conditionValues.isEmpty() && (conditionValue = conditionValues.get(0)) != null) {
            valueObject = conditionValue.isExpression() ? this.getObjectByPath(ruleId, conditionId, conditionValue.getConditionValue(), object) : conditionValue.getConditionValue();
        }
        Object resolvedObject = this.getObjectByPath(ruleId, conditionId, propertyPath, object);
        traceLogger.debug("Rule: {}, Condition: {}. PropertyPath: {}, Object: {}, valueObject: {}", new Object[]{ruleId, conditionId, propertyPath, resolvedObject, valueObject});
        RuleOperator operator = null;
        try {
            operator = RuleOperator.fromString(opCode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        boolean result = false;
        if (operator != null) {
            traceLogger.debug("Rule: {}, Condition: {}. Operator: {}", new Object[]{ruleId, conditionId, operator});
            switch (operator) {
                case EQUALS: {
                    result = this.evaluateEquals(ruleId, conditionId, resolvedObject, valueObject);
                    break;
                }
                case NOT_EQUALS: {
                    result = !this.evaluateEquals(ruleId, conditionId, resolvedObject, valueObject);
                    break;
                }
                case CONTAINS: {
                    result = this.evaluateContains(ruleId, conditionId, resolvedObject, valueObject);
                    break;
                }
                case NOT_CONTAINS: {
                    result = !this.evaluateContains(ruleId, conditionId, resolvedObject, valueObject);
                    break;
                }
                case IN_LIST: {
                    result = this.evaluateInList(ruleId, conditionId, resolvedObject, conditionValues);
                    break;
                }
                case NOT_IN_LIST: {
                    result = !this.evaluateInList(ruleId, conditionId, resolvedObject, conditionValues);
                    break;
                }
                case GREATER_THAN: {
                    result = this.evaluateGreaterThan(ruleId, conditionId, resolvedObject, valueObject);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    result = this.evaluateGreaterThanOrEqual(ruleId, conditionId, resolvedObject, valueObject);
                    break;
                }
                case LESS_THAN: {
                    result = this.evaluateLessThan(ruleId, conditionId, resolvedObject, valueObject);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    result = this.evaluateLessThanOrEqual(ruleId, conditionId, resolvedObject, valueObject);
                    break;
                }
                case IS_NULL: {
                    result = this.isNull(resolvedObject);
                    break;
                }
                case IS_NOT_NULL: {
                    result = !this.isNull(resolvedObject);
                    break;
                }
                case IS_EMPTY: {
                    result = this.isEmpty(resolvedObject);
                    break;
                }
                case IS_NOT_EMPTY: {
                    result = !this.isEmpty(resolvedObject);
                    break;
                }
                case IS_BLANK: {
                    result = this.isBlank(resolvedObject);
                    break;
                }
                case IS_NOT_BLANK: {
                    result = !this.isBlank(resolvedObject);
                    break;
                }
                case BEFORE: {
                    result = this.evaluateBefore(ruleId, conditionId, resolvedObject, valueObject, conditionValue == null ? null : conditionValue.getDateFormat());
                    break;
                }
                case AFTER: {
                    result = this.evaluateAfter(ruleId, conditionId, resolvedObject, valueObject, conditionValue == null ? null : conditionValue.getDateFormat());
                    break;
                }
                case ON: {
                    result = this.evaluateOn(ruleId, conditionId, resolvedObject, valueObject, conditionValue == null ? null : conditionValue.getDateFormat());
                    break;
                }
                case LENGTH_EQUALS: {
                    result = this.evaluateLenEq(ruleId, conditionId, resolvedObject, valueObject, conditionValue == null ? null : conditionValue.getValueTypeCode());
                    break;
                }
                case LENGTH_GREATER_THAN: {
                    result = this.evaluateLenGt(ruleId, conditionId, resolvedObject, valueObject, conditionValue == null ? null : conditionValue.getValueTypeCode());
                    break;
                }
                case LENGTH_LESS_THAN: {
                    result = this.evaluateLenLt(ruleId, conditionId, resolvedObject, valueObject, conditionValue == null ? null : conditionValue.getValueTypeCode());
                    break;
                }
                case MATCH: {
                    result = this.evaluateMatch(ruleId, conditionId, resolvedObject, valueObject, conditionValue == null ? null : conditionValue.getRegexFlags());
                    break;
                }
                case NOT_MATCH: {
                    result = !this.evaluateMatch(ruleId, conditionId, resolvedObject, valueObject, conditionValue == null ? null : conditionValue.getRegexFlags());
                }
            }
        } else {
            CustomOperator customOperator = customOperatorRegistry.get(opCode);
            if (customOperator != null) {
                traceLogger.debug("Rule: {}, Condition: {}. CustomOperator: {}", new Object[]{ruleId, conditionId, customOperator.getOperatorName()});
                result = customOperator.evaluate(ruleId, conditionId, resolvedObject, valueObject, conditionValues);
            } else {
                String errorMsg = "Invalid operator! Operator code " + opCode + " is not supported";
                logger.error("Error evaluating condition in rule {}, condition {}: {}", new Object[]{ruleId, conditionId, errorMsg});
                throw new InvalidOperatorException(errorMsg, ruleId, conditionId, opCode);
            }
        }
        traceLogger.debug("Rule: {}, Condition: {}. Result: {}", new Object[]{ruleId, conditionId, result});
        return result;
    }

    public Object getObjectByPath(String ruleId, String conditionId, String propertyPath, Object object) throws RuleEngineException {
        String[] properties;
        if (object == null || propertyPath == null) {
            return object;
        }
        String key = propertyPath + ":" + System.identityHashCode(object);
        Map<String, Object> cache = objectCache.get();
        if (cache.containsKey(key)) {
            return cache.get(key);
        }
        Object current = object;
        for (String subProperty : properties = propertyPath.split("\\.")) {
            if (current == null) break;
            if (current instanceof Map) {
                current = ((Map)current).get(subProperty);
                continue;
            }
            if (current instanceof List) {
                try {
                    current = ((List)current).get(Integer.parseInt(subProperty));
                    continue;
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    String errorMsg = "Number format exception or Index out of bound exception with object " + object + " in getObjectByPath for propertyPath " + propertyPath;
                    logger.error("Error evaluating condition in rule {}, condition {}: {}", new Object[]{ruleId, conditionId, errorMsg, e});
                    throw new ConditionEvaluationException(errorMsg, ruleId, conditionId);
                }
            }
            Class<?> clazz = current.getClass();
            Method[] accessors = this.getAccessors(clazz);
            boolean found = false;
            for (Method accessor : accessors) {
                if (!accessor.getName().substring("get".length()).equals(RuleEvaluator.capitalizeFirstLetter(subProperty))) continue;
                try {
                    current = accessor.invoke(current, (Object[])EMPTY_CLASS_LIST);
                    found = true;
                    break;
                }
                catch (Exception e) {
                    String errorMsg = "Invocation error with object " + object + " in getObjectByPath for propertyPath " + propertyPath;
                    logger.error("Error evaluating condition in rule {}, condition {}: {}", new Object[]{ruleId, conditionId, errorMsg, e});
                    throw new ConditionEvaluationException(errorMsg, ruleId, conditionId);
                }
            }
            if (found) continue;
            return null;
        }
        cache.put(key, current);
        return current;
    }

    private boolean evaluateEquals(String ruleId, String conditionId, Object object, Object valueObject) throws RuleEngineException {
        if (object == null || valueObject == null) {
            return object == null && valueObject == null;
        }
        TypeSpecificOperation<?> typeSpecificOperation = this.typeStrategies.get(object.getClass());
        if (typeSpecificOperation == null) {
            return object.equals(valueObject);
        }
        return typeSpecificOperation.equals(ruleId, conditionId, object, valueObject);
    }

    private boolean evaluateContains(String ruleId, String conditionId, Object object, Object valueObject) throws RuleEngineException {
        if (object == null || valueObject == null) {
            return object == null && valueObject == null;
        }
        if (valueObject instanceof String) {
            return object.toString().indexOf((String)valueObject) >= 0;
        }
        String errorMsg = "Contains evaluation with type different than string " + object.getClass();
        logger.error("Error evaluating condition in rule {}, condition {}: {}", new Object[]{ruleId, conditionId, errorMsg});
        return false;
    }

    private boolean evaluateInList(String ruleId, String conditionId, Object object, List valueConditions) throws RuleEngineException {
        if (object == null || valueConditions == null || valueConditions.isEmpty()) {
            return object == null && (valueConditions == null || valueConditions.isEmpty());
        }
        boolean match = false;
        ListIterator it = valueConditions.listIterator();
        while (!match && it.hasNext()) {
            RuleConditionValue value = (RuleConditionValue)it.next();
            Object valueObject = this.convertConditionValue(ruleId, conditionId, object, value.getConditionValue(), null);
            if (object == null || valueObject == null) {
                match = object == null && valueObject == null;
                continue;
            }
            match = object.equals(valueObject);
        }
        return match;
    }

    private boolean evaluateGreaterThan(String ruleId, String conditionId, Object object, Object valueObject) throws RuleEngineException {
        return this.compareNumeric(ruleId, conditionId, object, valueObject) > 0;
    }

    private boolean evaluateGreaterThanOrEqual(String ruleId, String conditionId, Object object, Object valueObject) throws RuleEngineException {
        return this.compareNumeric(ruleId, conditionId, object, valueObject) >= 0;
    }

    private boolean evaluateLessThan(String ruleId, String conditionId, Object object, Object valueObject) throws RuleEngineException {
        return this.compareNumeric(ruleId, conditionId, object, valueObject) < 0;
    }

    private boolean evaluateLessThanOrEqual(String ruleId, String conditionId, Object object, Object valueObject) throws RuleEngineException {
        return this.compareNumeric(ruleId, conditionId, object, valueObject) <= 0;
    }

    private int compareNumeric(String ruleId, String conditionId, Object object, Object valueObject) throws RuleEngineException {
        if (!(object instanceof Number)) {
            String errorMsg = "Object is not a number:" + object.getClass();
            logger.error("Error evaluating condition in rule {}, condition {}: {}", new Object[]{ruleId, conditionId, errorMsg});
            throw new ConditionEvaluationException(errorMsg, ruleId, conditionId);
        }
        TypeSpecificOperation<?> typeSpecificOperation = this.typeStrategies.get(object.getClass());
        if (typeSpecificOperation == null) {
            return 0;
        }
        return typeSpecificOperation.compare(ruleId, conditionId, object, valueObject);
    }

    private boolean evaluateBefore(String ruleId, String conditionId, Object object, Object valueObject, String dateFormat) throws RuleEngineException {
        return this.compareDate(ruleId, conditionId, object, valueObject, dateFormat) < 0;
    }

    private boolean evaluateAfter(String ruleId, String conditionId, Object object, Object valueObject, String dateFormat) throws RuleEngineException {
        return this.compareDate(ruleId, conditionId, object, valueObject, dateFormat) > 0;
    }

    private boolean evaluateOn(String ruleId, String conditionId, Object object, Object valueObject, String dateFormat) throws RuleEngineException {
        return this.compareDate(ruleId, conditionId, object, valueObject, dateFormat) == 0;
    }

    private int compareDate(String ruleId, String conditionId, Object object, Object valueObject, String dateFormat) throws RuleEngineException {
        TypeSpecificOperation<?> typeSpecificOperation = this.typeStrategies.get(object.getClass());
        if (typeSpecificOperation == null) {
            return 0;
        }
        return typeSpecificOperation.compare(ruleId, conditionId, object, valueObject);
    }

    private boolean evaluateLenEq(String ruleId, String conditionId, Object object, Object valueObject, String valueTypeCode) throws RuleEngineException {
        if (valueObject == null) {
            return false;
        }
        return this.compareStringLength(ruleId, conditionId, object, valueObject, valueTypeCode) == 0;
    }

    private boolean evaluateLenGt(String ruleId, String conditionId, Object object, Object valueObject, String valueTypeCode) throws RuleEngineException {
        if (valueObject == null) {
            return false;
        }
        return this.compareStringLength(ruleId, conditionId, object, valueObject, valueTypeCode) > 0;
    }

    private boolean evaluateLenLt(String ruleId, String conditionId, Object object, Object valueObject, String valueTypeCode) throws RuleEngineException {
        if (valueObject == null) {
            return false;
        }
        return this.compareStringLength(ruleId, conditionId, object, valueObject, valueTypeCode) < 0;
    }

    private int compareStringLength(String ruleId, String conditionId, Object object, Object valueObject, String valueTypeCode) throws RuleEngineException {
        if (object == null) {
            if (valueObject == null) {
                return 0;
            }
            return -1;
        }
        if (!(object instanceof String)) {
            String errorMsg = "Object is not a String:" + object.getClass();
            logger.error("Error evaluating condition in rule {}, condition {}: {}", new Object[]{ruleId, conditionId, errorMsg});
            throw new ConditionEvaluationException(errorMsg, ruleId, conditionId);
        }
        TypeSpecificOperation<?> typeSpecificOperation = this.typeStrategies.get(object.getClass());
        if (typeSpecificOperation == null) {
            return 0;
        }
        return typeSpecificOperation.compareLength(ruleId, conditionId, object, valueObject, valueTypeCode);
    }

    private boolean evaluateMatch(String ruleId, String conditionId, Object object, Object valueObject, String regexFlags) throws RuleEngineException {
        if (object == null) {
            if (valueObject == null) {
                traceLogger.debug("evaluateMatch in rule {} and condition {} : result {} with object {} and valueObject {}", new Object[]{ruleId, conditionId, true, null, null});
                return true;
            }
            traceLogger.debug("evaluateMatch in rule {} and condition {} : result {} with object {} and valueObject {}", new Object[]{ruleId, conditionId, false, null, valueObject});
            return false;
        }
        if (!(object instanceof String)) {
            String errorMsg = "Object is not a String:" + object.getClass();
            logger.error("Error evaluating condition in rule {}, condition {}: {}", new Object[]{ruleId, conditionId, errorMsg});
            throw new ConditionEvaluationException(errorMsg, ruleId, conditionId);
        }
        Object value = valueObject;
        if (!(valueObject instanceof String)) {
            value = valueObject.toString();
            traceLogger.debug("evaluateMatch in rule {} and condition {} : valueObject {} is not a string and it is converted to string {}", new Object[]{ruleId, conditionId, valueObject, value});
        }
        if (value != null && !((String)value).isEmpty()) {
            String regex = (String)value;
            int flags = 0;
            if (regexFlags != null) {
                if (regexFlags.contains("i")) {
                    flags |= 2;
                }
                if (regexFlags.contains("m")) {
                    flags |= 8;
                }
                if (regexFlags.contains("s")) {
                    flags |= 0x20;
                }
                if (regexFlags.contains("u")) {
                    flags |= 0x40;
                }
                if (regexFlags.contains("x")) {
                    flags |= 4;
                }
                traceLogger.debug("evaluateMatch in rule {} and condition {} : regexFlags {} is not null.", new Object[]{ruleId, conditionId, regexFlags});
            }
            int finalFlags = flags;
            String key = regex + ":" + finalFlags;
            traceLogger.debug("evaluateMatch in rule {} and condition {} : finalFlags {} and key {}.", new Object[]{ruleId, conditionId, finalFlags, key});
            Pattern pattern = this.patternCache.get(key);
            if (pattern == null) {
                pattern = Pattern.compile(regex, finalFlags);
                this.patternCache.put(key, pattern);
                traceLogger.debug("evaluateMatch in rule {} and condition {} : create a new pattern {} and save it into cache for key {}.", new Object[]{ruleId, conditionId, pattern, key});
            } else {
                traceLogger.debug("evaluateMatch in rule {} and condition {} : found a pattern {} from cache for key {}.", new Object[]{ruleId, conditionId, pattern, key});
            }
            boolean result = pattern.matcher((String)object).matches();
            traceLogger.debug("evaluateMatch in rule {} and condition {} : result is {}.", new Object[]{ruleId, conditionId, result});
            return result;
        }
        String errorMsg = "Condition Value is empty";
        logger.error("Error evaluating condition in rule {}, condition {}: {}", new Object[]{ruleId, conditionId, errorMsg});
        throw new ConditionEvaluationException(errorMsg, ruleId, conditionId);
    }

    private boolean isNull(Object val) {
        return val == null;
    }

    private boolean isEmpty(Object val) {
        return val == null || val.toString().length() == 0;
    }

    private boolean isBlank(Object val) {
        return val == null || val.toString().trim().length() == 0;
    }

    private Object convertConditionValue(String ruleId, String conditionId, Object object, String valueStr, String dateFormat) throws RuleEngineException {
        TypeSpecificOperation<?> typeSpecificOperation = this.typeStrategies.get(object.getClass());
        if (typeSpecificOperation == null) {
            return null;
        }
        return typeSpecificOperation.convert(ruleId, conditionId, object, valueStr, dateFormat);
    }

    public Object resolveVariable(String variable, Map objMap, Map resultMap) {
        if (variable == null || variable.isEmpty()) {
            return variable;
        }
        if (variable.startsWith("${") && variable.endsWith("}")) {
            String propertyPath = variable.substring(2, variable.length() - 1);
            try {
                Object obj = this.getObjectByPath(null, null, propertyPath, objMap);
                return obj;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (variable.startsWith("^{") && variable.endsWith("}")) {
            String conditionId = variable.substring(2, variable.length() - 1);
            if (resultMap != null && resultMap.containsKey(conditionId)) {
                return resultMap.get(conditionId);
            }
            return null;
        }
        return variable;
    }

    private Method[] getAccessors(Class clazz) {
        Method[] allMethods = (Method[])accessorMap.get(clazz);
        if (allMethods == null) {
            allMethods = clazz.getMethods();
            ArrayList<Method> accessors = new ArrayList<Method>(allMethods.length);
            for (int i = 0; i < allMethods.length; ++i) {
                allMethods[i].setAccessible(true);
                if (!allMethods[i].getName().startsWith("get") || allMethods[i].getParameterTypes().length != 0) continue;
                accessors.add(allMethods[i]);
            }
            allMethods = accessors.toArray(new Method[accessors.size()]);
            accessorMap.put(clazz, allMethods);
        }
        return allMethods;
    }

    public static String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    static {
        objectCache = ThreadLocal.withInitial(HashMap::new);
        customOperatorRegistry = new HashMap<String, CustomOperator>();
        simpleTypes = new HashSet();
        simpleTypes.add("java.lang.String");
        simpleTypes.add("java.lang.Integer");
        simpleTypes.add("java.math.BigDecimal");
        simpleTypes.add("java.math.BigInteger");
        simpleTypes.add("java.lang.Long");
        simpleTypes.add("java.lang.Boolean");
        simpleTypes.add("java.lang.Byte");
        simpleTypes.add("java.lang.Character");
        simpleTypes.add("java.lang.Double");
        simpleTypes.add("java.lang.Float");
        simpleTypes.add("java.lang.Short");
        simpleTypes.add("java.sql.Timestamp");
    }
}

