/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.RXTXVersion;
import gnu.io.SerialManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class RXTXCommDriver
implements CommDriver {
    private static Set<String> ports;
    private static final boolean debug = false;
    private static final boolean devel = false;
    private static final boolean noVersionOutput;
    private String deviceDirectory;
    private String osName;

    private native boolean registerKnownPorts(int var1);

    private native boolean isPortPrefixValid(String var1);

    private native boolean testRead(String var1, int var2);

    private native String getDeviceDirectory();

    private static native String nativeGetVersion();

    public static String nativeGetVersionWrapper() throws UnsatisfiedLinkError {
        return RXTXCommDriver.nativeGetVersion();
    }

    public Set<String> getPortIdentifiers() {
        Enumeration pe;
        ports = new HashSet<String>();
        this.registerScannedPorts(1);
        try {
            pe = CommPortIdentifier.getPortIdentifiers();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            return null;
        }
        if (pe != null) {
            while (pe.hasMoreElements()) {
                CommPortIdentifier com = (CommPortIdentifier)pe.nextElement();
                switch (com.getPortType()) {
                    case 1: {
                        if (com.getName().matches("^/.+/cu\\..+$") || com.getName().matches("^/.+/tty\\.Bluetooth.+$")) break;
                        boolean inList = false;
                        for (String s : ports) {
                            if (!com.getName().contains(s)) continue;
                            inList = true;
                        }
                        if (inList) break;
                        ports.add(com.getName());
                    }
                }
            }
        }
        return ports;
    }

    private final String[] getValidPortPrefixes(String[] CandidatePortPrefixes) {
        String[] ValidPortPrefixes = new String[this.getScannedBufferSize()];
        if (CandidatePortPrefixes == null) {
            // empty if block
        }
        int i = 0;
        for (int j = 0; j < CandidatePortPrefixes.length; ++j) {
            if (!this.isPortPrefixValid(CandidatePortPrefixes[j])) continue;
            ValidPortPrefixes[i++] = CandidatePortPrefixes[j];
        }
        String[] returnArray = new String[i];
        System.arraycopy(ValidPortPrefixes, 0, returnArray, 0, i);
        if (ValidPortPrefixes[0] == null) {
            // empty if block
        }
        return returnArray;
    }

    private void checkSolaris(String PortName, int PortType) {
        char[] p = new char[]{'['};
        p[0] = 97;
        while (p[0] < '{') {
            if (this.testRead(PortName.concat(new String(p)), PortType)) {
                CommPortIdentifier.addPortName(PortName.concat(new String(p)), PortType, this);
            }
            p[0] = (char)(p[0] + '\u0001');
        }
        p[0] = 48;
        while (p[0] <= '9') {
            if (this.testRead(PortName.concat(new String(p)), PortType)) {
                CommPortIdentifier.addPortName(PortName.concat(new String(p)), PortType, this);
            }
            p[0] = (char)(p[0] + '\u0001');
        }
    }

    private void registerValidPorts(String[] CandidateDeviceNames, String[] ValidPortPrefixes, int PortType, boolean performTestRead) {
        int i = 0;
        int p = 0;
        if (this.osName.toLowerCase().indexOf("windows") != -1 && !performTestRead) {
            for (i = 0; i < CandidateDeviceNames.length; ++i) {
                CommPortIdentifier.addPortName(CandidateDeviceNames[i], PortType, this);
            }
            return;
        }
        if (CandidateDeviceNames != null && ValidPortPrefixes != null) {
            for (i = 0; i < CandidateDeviceNames.length; ++i) {
                for (p = 0; p < ValidPortPrefixes.length; ++p) {
                    String V = ValidPortPrefixes[p];
                    int VL = V.length();
                    String C = CandidateDeviceNames[i];
                    if (C.length() < VL) continue;
                    String CU = C.substring(VL).toUpperCase();
                    String Cl = C.substring(VL).toLowerCase();
                    if (!C.regionMatches(0, V, 0, VL) || !CU.equals(Cl)) continue;
                    Object PortName = this.osName.toLowerCase().indexOf("windows") == -1 ? this.deviceDirectory + C : C;
                    if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                        this.checkSolaris((String)PortName, PortType);
                        continue;
                    }
                    if (!this.testRead((String)PortName, PortType)) continue;
                    CommPortIdentifier.addPortName((String)PortName, PortType, this);
                    boolean ok = true;
                    for (String s : ports) {
                        if (!s.contains((CharSequence)PortName)) continue;
                        ok = false;
                    }
                    if (!ok) continue;
                    ports.add((String)PortName);
                }
            }
        }
    }

    @Override
    public void initialize() {
        this.osName = System.getProperty("os.name");
        this.deviceDirectory = this.getDeviceDirectory();
        if (!this.registerSpecifiedPorts(1) && !this.registerKnownPorts(1)) {
            this.registerScannedPorts(1);
        }
    }

    private void addSpecifiedPorts(String names, int PortType) {
        String pathSep = System.getProperty("path.separator", ":");
        StringTokenizer tok = new StringTokenizer(names, pathSep);
        while (tok.hasMoreElements()) {
            String PortName = tok.nextToken();
            if (!this.testRead(PortName, PortType)) continue;
            CommPortIdentifier.addPortName(PortName, PortType, this);
        }
    }

    private boolean registerSpecifiedPorts(int PortType) {
        String val = null;
        Properties origp = System.getProperties();
        try {
            String ext_dir = System.getProperty("java.ext.dirs") + System.getProperty("file.separator");
            FileInputStream rxtx_prop = new FileInputStream(ext_dir + "gnu.io.rxtx.properties");
            Properties p = new Properties();
            p.load(rxtx_prop);
            System.setProperties(p);
            for (String string : p.keySet()) {
                System.setProperty(string, p.getProperty(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (PortType) {
            case 1: {
                val = System.getProperty("gnu.io.rxtx.SerialPorts");
                if (val != null) break;
                val = System.getProperty("gnu.io.SerialPorts");
                break;
            }
            case 2: {
                val = System.getProperty("gnu.io.rxtx.ParallelPorts");
                if (val != null) break;
                val = System.getProperty("gnu.io.ParallelPorts");
                break;
            }
        }
        System.setProperties(origp);
        if (val != null) {
            this.addSpecifiedPorts(val, PortType);
            return true;
        }
        return false;
    }

    private int getScannedBufferSize() {
        return 40960;
    }

    private void registerScannedPorts(int PortType) {
        String[] CandidateDeviceNames;
        this.osName = System.getProperty("os.name");
        this.deviceDirectory = this.getDeviceDirectory();
        boolean performTestRead = true;
        if (this.osName.toLowerCase().indexOf("windows") != -1) {
            boolean useFallback = true;
            String[] temp = new String[]{};
            if (RXTXCommDriver.isClassPresent("com.sun.jna.platform.win32.Advapi32Util")) {
                try {
                    temp = this.windowsGetSerialPortsFromRegistry();
                    performTestRead = false;
                    useFallback = false;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (useFallback) {
                int i;
                temp = new String[this.getScannedBufferSize() + 3];
                for (i = 1; i <= this.getScannedBufferSize(); ++i) {
                    temp[i - 1] = "COM" + i;
                }
                for (i = 1; i <= 3; ++i) {
                    temp[i + this.getScannedBufferSize() - 1] = "LPT" + i;
                }
            }
            CandidateDeviceNames = temp;
        } else if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
            String[] term = new String[2];
            int l = 0;
            File dev = null;
            dev = new File("/dev/term");
            if (dev.list().length > 0) {
                term[l++] = "term/";
            }
            String[] temp = new String[l];
            --l;
            while (l >= 0) {
                temp[l] = term[l];
                --l;
            }
            CandidateDeviceNames = temp;
        } else {
            File dev = new File(this.deviceDirectory);
            String[] temp = dev.list();
            CandidateDeviceNames = temp;
        }
        if (CandidateDeviceNames == null) {
            return;
        }
        String[] CandidatePortPrefixes = new String[]{};
        switch (PortType) {
            case 1: {
                if (this.osName.equals("Linux")) {
                    String[] Temp = new String[]{"ttyS", "ttySA", "ttyUSB", "ttyAMA", "rfcomm", "ttyircomm", "ttyACM", "DyIO", "Bootloader", "BowlerDevice", "DeltaDoodle", "dyio"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("Linux-all-ports")) {
                    String[] Temp = new String[]{"comx", "holter", "modem", "rfcomm", "ttyircomm", "ttycosa0c", "ttycosa1c", "ttyACM", "DyIO", "Bootloader", "BowlerDevice", "DeltaDoodle", "dyio", "ttyC", "ttyCH", "ttyD", "ttyE", "ttyF", "ttyH", "ttyI", "ttyL", "ttyM", "ttyMX", "ttyP", "ttyR", "ttyS", "ttySI", "ttySR", "ttyT", "ttyUSB", "ttyV", "ttyW", "ttyX"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("qnx") != -1) {
                    String[] Temp = new String[]{"ser"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("Irix")) {
                    String[] Temp = new String[]{"ttyc", "ttyd", "ttyf", "ttym", "ttyq", "tty4d", "tty4f", "midi", "us"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] Temp = new String[]{"ttyd", "cuaa", "ttyA", "cuaA", "ttyu", "cuau", "ttyU", "cuaU", "ttyD", "cuaD", "ttyE", "cuaE", "ttyF", "cuaF", "ttyR", "cuaR", "stl"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("NetBSD")) {
                    String[] Temp = new String[]{"tty0"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                    String[] Temp = new String[]{"term/", "cua/"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("HP-UX")) {
                    String[] Temp = new String[]{"tty0p", "tty1p"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("UnixWare") || this.osName.equals("OpenUNIX")) {
                    String[] Temp = new String[]{"tty00s", "tty01s", "tty02s", "tty03s"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("OpenServer")) {
                    String[] Temp = new String[]{"tty1A", "tty2A", "tty3A", "tty4A", "tty5A", "tty6A", "tty7A", "tty8A", "tty9A", "tty10A", "tty11A", "tty12A", "tty13A", "tty14A", "tty15A", "tty16A", "ttyu1A", "ttyu2A", "ttyu3A", "ttyu4A", "ttyu5A", "ttyu6A", "ttyu7A", "ttyu8A", "ttyu9A", "ttyu10A", "ttyu11A", "ttyu12A", "ttyu13A", "ttyu14A", "ttyu15A", "ttyu16A"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("Compaq's Digital UNIX") || this.osName.equals("OSF1")) {
                    String[] Temp = new String[]{"tty0"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("BeOS")) {
                    String[] Temp = new String[]{"serial"};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.equals("Mac OS X")) {
                    String[] Temp = new String[]{"cu.KeyUSA28X191.", "tty.KeyUSA28X191.", "cu.KeyUSA28X181.", "tty.KeyUSA28X181.", "cu.KeyUSA19181.", "tty.KeyUSA19181."};
                    CandidatePortPrefixes = Temp;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("windows") == -1) break;
                String[] Temp = new String[]{"COM"};
                CandidatePortPrefixes = Temp;
                break;
            }
            case 2: {
                if (this.osName.equals("Linux")) {
                    String[] temp = new String[]{"lp"};
                    CandidatePortPrefixes = temp;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] temp = new String[]{"lpt"};
                    CandidatePortPrefixes = temp;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("windows") != -1) {
                    String[] temp = new String[]{"LPT"};
                    CandidatePortPrefixes = temp;
                    break;
                }
                String[] temp = new String[]{};
                CandidatePortPrefixes = temp;
                break;
            }
        }
        this.registerValidPorts(CandidateDeviceNames, CandidatePortPrefixes, PortType, performTestRead);
    }

    private String[] windowsGetSerialPortsFromRegistry() throws Exception {
        TreeMap map = Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"HARDWARE\\DEVICEMAP\\SERIALCOMM");
        ArrayList<String> ports = new ArrayList<String>(map.size());
        for (Object p : map.values()) {
            if (p == null || !p.toString().startsWith("COM")) continue;
            ports.add(p.toString());
        }
        return ports.toArray(new String[0]);
    }

    private static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public CommPort getCommPort(String PortName, int PortType) {
        try {
            switch (PortType) {
                case 1: {
                    if (this.osName.toLowerCase().indexOf("windows") == -1) {
                        return new RXTXPort(PortName);
                    }
                    return new RXTXPort(this.deviceDirectory + PortName);
                }
            }
        }
        catch (PortInUseException portInUseException) {
            // empty catch block
        }
        return null;
    }

    public void Report(String arg) {
        System.out.println(arg);
    }

    static {
        String LibVersion;
        ports = new HashSet<String>();
        noVersionOutput = "true".equals(System.getProperty("gnu.io.rxtx.NoVersionOutput"));
        if (ports == null) {
            ports = new HashSet<String>();
        }
        SerialManager.getInstance();
        String JarVersion = RXTXVersion.getVersion();
        try {
            LibVersion = RXTXVersion.nativeGetVersion();
        }
        catch (Error UnsatisfiedLinkError2) {
            LibVersion = RXTXCommDriver.nativeGetVersion();
        }
        if (!JarVersion.equals(LibVersion)) {
            // empty if block
        }
    }
}

