/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.NativeResourceException;
import gnu.io.RXTXCommDriver;
import gnu.io.RXTXPort;
import gnu.io.SerialPortEventListener;
import gnu.io.factory.RxTxPortCreator;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TooManyListenersException;

public class NRSerialPort {
    private RXTXPort serial;
    private String port = null;
    private boolean connected = false;
    private int baud = 115200;

    public NRSerialPort(String port, int baud) {
        this.setPort(port);
        this.setBaud(baud);
    }

    public boolean connect() {
        if (this.isConnected()) {
            System.err.println(this.port + " is already connected.");
            return true;
        }
        try {
            this.serial = new RxTxPortCreator().createPort(this.port);
            this.serial.setSerialPortParams(this.getBaud(), 8, 1, 0);
            this.setConnected(true);
        }
        catch (NativeResourceException e) {
            throw new NativeResourceException(e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Failed to connect on port: " + this.port + " exception: ");
            e.printStackTrace();
            this.setConnected(false);
        }
        if (this.isConnected()) {
            this.serial.notifyOnDataAvailable(true);
        }
        return this.isConnected();
    }

    public InputStream getInputStream() {
        return this.serial.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.serial.getOutputStream();
    }

    private void setPort(String port) {
        this.port = port;
    }

    public void disconnect() {
        try {
            try {
                this.getInputStream().close();
                this.getOutputStream().close();
                this.serial.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.serial = null;
            this.setConnected(false);
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeResourceException(e.getMessage());
        }
    }

    public static Set<String> getAvailableSerialPorts() {
        HashSet<String> available = new HashSet<String>();
        try {
            RXTXCommDriver d = new RXTXCommDriver();
            Set<String> av = d.getPortIdentifiers();
            ArrayList<String> strs = new ArrayList<String>();
            for (String s : av) {
                strs.add(0, s);
            }
            for (String s : strs) {
                available.add(s);
            }
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            throw new NativeResourceException(e.getMessage());
        }
        return available;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        if (this.connected == connected) {
            return;
        }
        this.connected = connected;
    }

    public void setBaud(int baud) {
        this.baud = baud;
    }

    public int getBaud() {
        return this.baud;
    }

    public int enableRs485(boolean busEnableActiveLow, int delayBusEnableBeforeSendMs, int delayBusEnableAfterSendMs) {
        if (this.serial == null) {
            return -1;
        }
        return this.serial.enableRs485(busEnableActiveLow, delayBusEnableBeforeSendMs, delayBusEnableAfterSendMs);
    }

    public void notifyOnDataAvailable(boolean b) {
        this.serial.notifyOnDataAvailable(b);
    }

    public void addEventListener(SerialPortEventListener lsnr) throws TooManyListenersException {
        this.serial.addEventListener(lsnr);
    }

    public void removeEventListener() {
        this.serial.removeEventListener();
    }

    public RXTXPort getSerialPortInstance() {
        return this.serial;
    }
}

