/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import com.newrelic.agent.compile.RewriterAgent;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

class NewRelicGradlePlugin
implements Plugin<Project> {
    NewRelicGradlePlugin() {
    }

    public void apply(Project target) {
        String jarFilePath;
        Logger logger = target.getLogger();
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        String pid = nameOfRunningVM.substring(0, p);
        logger.info("[newrelic] Dynamically loading New Relic instrumentation...");
        try {
            jarFilePath = RewriterAgent.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().toString();
            jarFilePath = new File(jarFilePath).getCanonicalPath();
            logger.info("[newrelic] Found New Relic instrumentation within " + jarFilePath);
        }
        catch (URISyntaxException e) {
            logger.error("[newrelic] Unable to find New Relic instrumentation jar");
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error("[newrelic] Unable to find New Relic instrumentation jar");
            throw new RuntimeException(e);
        }
        try {
            VirtualMachine vm = VirtualMachine.attach(pid);
            vm.loadAgent(jarFilePath, System.getProperty("NewRelic.AgentArgs"));
            vm.detach();
        }
        catch (Exception e) {
            logger.error("[newrelic] Error encountered while loading the New Relic agent", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

