/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.obfuscation;

import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.newrelic.agent.util.BuildId;
import com.newrelic.agent.util.Streams;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.slf4j.Logger;

public class Proguard {
    public static final String NR_PROPERTIES = "newrelic.properties";
    public static final String MAPPING_FILENAME = "mapping.txt";
    public static final String MAPPING_FILE_KEY = "com.newrelic.mapping.txt";
    public static final String MAPPING_PROVIDER_KEY = "com.newrelic.mapping.provider";
    public static final String VARIANT_KEY = "com.newrelic.mapping.variant";
    public static final String LOGLEVEL_KEY = "com.newrelic.loglevel";
    public static final String PROJECT_ROOT_KEY = "com.newrelic.projectroot";
    public static final String NR_MAP_PREFIX = "# NR_BUILD_ID -> ";
    private static final String PROP_NR_APP_TOKEN = "com.newrelic.application_token";
    private static final String PROP_UPLOADING_ENABLED = "com.newrelic.enable_proguard_upload";
    private static final String PROP_MAPPING_API_HOST = "com.newrelic.mapping_upload_host";
    private static final String PROP_COMPRESSED_UPLOADS = "com.newrelic.compressed_uploads";
    private static final String PROP_SSL_CONNECTION = "com.newrelic.ssl_connection";
    private static final String DEFAULT_MAPPING_API_HOST = "mobile-symbol-upload.newrelic.com";
    private static final String DEFAULT_REGION_MAPPING_API_HOST = "mobile-symbol-upload.%s.nr-data.net";
    private static final String MAPPING_API_PATH = "/symbol";
    private static final String NR_COMPILER_PREFIX = "# compiler: ";
    private static final String NR_COMPILER_VERSION_PREFIX = "# compiler_version: ";
    private static final String NEWLN = System.getProperty("line.separator", "\r\n");
    private final Logger log;
    private String projectRoot;
    private String licenseKey = null;
    private boolean uploadingEnabled = true;
    private String mappingApiHost = "mobile-symbol-upload.newrelic.com";
    private boolean compressedUploads = true;
    private boolean sslConnection = true;
    private static Map<String, String> agentOptions = Collections.emptyMap();
    private static String buildId = BuildId.getBuildId((String)"release");
    private Properties newRelicProps;

    public Proguard(Logger log, Map<String, String> agentOptions) {
        this.log = log;
        Proguard.agentOptions = agentOptions;
    }

    public void findAndSendMapFile() {
        if (this.getProjectRoot() != null) {
            if (!this.fetchConfiguration()) {
                return;
            }
            File projectRoot = new File(this.getProjectRoot());
            Collection<File> files = new ArrayList();
            if (agentOptions.containsKey(MAPPING_FILE_KEY)) {
                File mappingFile = new File(agentOptions.get(MAPPING_FILE_KEY));
                if (mappingFile.exists()) {
                    files.add(mappingFile);
                } else {
                    this.log.warn("Mapping file [" + mappingFile.getAbsolutePath() + "] doesn't exist");
                }
            } else {
                IOFileFilter fileFilter = FileFilterUtils.nameFileFilter((String)MAPPING_FILENAME);
                files = FileUtils.listFiles((File)projectRoot, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
            }
            if (files.isEmpty()) {
                this.log.error("While evidence of ProGuard/DexGuard was detected, New Relic failed to find 'mapping.txt' files.");
                this.logRecourse();
                return;
            }
            for (File file : files) {
                try {
                    if (!this.shouldUploadMapFile(file)) continue;
                    if (this.uploadingEnabled) {
                        this.sendMapping(file);
                        continue;
                    }
                    this.log.error("Map uploads are disabled!");
                }
                catch (IOException e) {
                    this.log.error("Unable to open ProGuard/DexGuard 'mapping.txt' file: " + e.getLocalizedMessage());
                    this.logRecourse();
                }
            }
        }
    }

    boolean shouldUploadMapFile(File file) throws IOException {
        block14: {
            if (file.exists()) {
                try (ReversedLinesFileReader revReader = new ReversedLinesFileReader(file);){
                    boolean bl;
                    String lastLine = revReader.readLine();
                    revReader.close();
                    if (lastLine == null || lastLine.isEmpty()) {
                        this.log.warn("Map [" + file.getAbsolutePath() + "] is empty!");
                        break block14;
                    }
                    if (lastLine.startsWith(NR_MAP_PREFIX)) {
                        buildId = lastLine.substring(NR_MAP_PREFIX.length());
                        this.log.info("Map [" + file.getAbsolutePath() + "] has already been tagged with buildID [" + buildId + "] - resending.");
                        boolean bl2 = true;
                        return bl2;
                    }
                    String variant = agentOptions.get(VARIANT_KEY);
                    buildId = BuildId.getBuildId((String)variant);
                    this.log.info("Tagging map [" + file.getAbsolutePath() + "] with buildID [" + buildId + "]");
                    try (FileWriter fileWriter = new FileWriter(file, true);){
                        fileWriter.write(NR_MAP_PREFIX + buildId + NEWLN);
                        fileWriter.close();
                        bl = true;
                    }
                    return bl;
                }
            }
        }
        return false;
    }

    String getProjectRoot() {
        if (this.projectRoot == null) {
            String encodedProjectRoot = agentOptions.get(PROJECT_ROOT_KEY);
            if (encodedProjectRoot == null) {
                this.log.info("Unable to determine project root, falling back to CWD.");
                this.projectRoot = System.getProperty("user.dir");
            } else {
                this.projectRoot = new String(BaseEncoding.base64().decode((CharSequence)encodedProjectRoot));
            }
        }
        return this.projectRoot;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fetchConfiguration() {
        try (BufferedReader propsReader = new BufferedReader(new FileReader(this.getProjectRoot() + File.separator + NR_PROPERTIES));){
            this.newRelicProps = new Properties();
            this.newRelicProps.load(propsReader);
            this.uploadingEnabled = this.newRelicProps.getProperty(PROP_UPLOADING_ENABLED, "true").equals("true");
            this.compressedUploads = this.newRelicProps.getProperty(PROP_COMPRESSED_UPLOADS, "true").equals("true");
            this.sslConnection = this.newRelicProps.getProperty(PROP_SSL_CONNECTION, "true").equals("true");
            this.licenseKey = this.newRelicProps.getProperty(PROP_NR_APP_TOKEN, null);
            if (this.licenseKey == null) {
                this.log.error("Unable to find a value for com.newrelic.application_token in 'newrelic.properties'");
                this.logRecourse();
                boolean bl = false;
                return bl;
            }
            this.mappingApiHost = this.newRelicProps.getProperty(PROP_MAPPING_API_HOST, null);
            if (this.mappingApiHost != null) return true;
            String region = this.parseRegionFromApplicationToken(this.licenseKey);
            if (region == null) return true;
            this.mappingApiHost = String.format(Locale.getDefault(), DEFAULT_REGION_MAPPING_API_HOST, region);
            return true;
        }
        catch (FileNotFoundException e) {
            this.log.error("Unable to find 'newrelic.properties' in the project root (" + this.getProjectRoot() + "): " + e.getLocalizedMessage());
            this.logRecourse();
            return false;
        }
        catch (IOException e) {
            this.log.error("Unable to read 'newrelic.properties' in the project root (" + this.getProjectRoot() + "): " + e.getLocalizedMessage());
            this.logRecourse();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendMapping(File mapFile) throws IOException {
        int USEFUL_BUFFER_SIZE = 65536;
        if (mapFile.length() <= 0L) {
            this.log.error("Tried to send a zero-length map file!");
            return;
        }
        HttpURLConnection connection = null;
        try {
            String mapProvider;
            block71: {
                Object host = DEFAULT_MAPPING_API_HOST;
                if (this.mappingApiHost != null) {
                    host = this.mappingApiHost;
                }
                if (!((String)host).startsWith("http")) {
                    host = (this.sslConnection ? "https://" : "http://") + (String)host;
                }
                URL url = new URL((String)host + MAPPING_API_PATH);
                connection = (HttpURLConnection)url.openConnection();
                connection.setUseCaches(false);
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("X-App-License-Key", this.licenseKey);
                if (agentOptions.containsKey(LOGLEVEL_KEY) && agentOptions.get(LOGLEVEL_KEY).equalsIgnoreCase("debug")) {
                    this.log.debug("Map upload request is synchronous");
                    connection.setRequestProperty("X-APP-REQUEST-DEBUG", "NRMA");
                }
                if (this.compressedUploads) {
                    File zipFile = new File(mapFile.getAbsolutePath() + ".zip");
                    try (FileInputStream fis = new FileInputStream(mapFile);
                         FileOutputStream fos = new FileOutputStream(zipFile);
                         ZipOutputStream zos = new ZipOutputStream(fos);){
                        ZipEntry zipEntry = new ZipEntry(mapFile.getName());
                        zos.putNextEntry(zipEntry);
                        Streams.copy((InputStream)fis, (OutputStream)zos, (int)65536);
                        zos.finish();
                        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + MultipartFormWriter.boundary);
                        connection.setRequestProperty("Content-Length", String.valueOf(zipFile.length()));
                        mapFile = zipFile;
                        break block71;
                    }
                }
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            }
            OutputStream outputStrm = connection.getOutputStream();
            String providerHeader = null;
            if (agentOptions.containsKey(MAPPING_PROVIDER_KEY) && !Strings.isNullOrEmpty((String)(mapProvider = agentOptions.get(MAPPING_PROVIDER_KEY))) && !mapProvider.toLowerCase().startsWith("r8")) {
                providerHeader = Provider.decompose(mapProvider);
            }
            try (FileInputStream fis = new FileInputStream(mapFile);
                 DataOutputStream dos = new DataOutputStream(outputStrm);){
                if (this.compressedUploads) {
                    MultipartFormWriter formWriter = new MultipartFormWriter(dos, 65536);
                    formWriter.writeFilePart("zip", mapFile, fis);
                    formWriter.finish();
                } else {
                    dos.writeBytes("proguard=");
                    if (!Strings.isNullOrEmpty((String)providerHeader)) {
                        dos.writeBytes(providerHeader);
                    }
                    try (BufferedInputStream bis = new BufferedInputStream(fis);){
                        byte[] cbuf = new byte[65536];
                        while (bis.read(cbuf, 0, 65536) != -1) {
                            if (cbuf.length <= 0) continue;
                            dos.writeBytes(URLEncoder.encode(new String(cbuf), "UTF-8"));
                        }
                    }
                }
                dos.writeBytes("&buildId=" + buildId);
                dos.flush();
                this.log.debug("sendMapping writing [" + dos.size() + "] bytes" + (this.compressedUploads ? " (compressed)" : ""));
            }
            finally {
                outputStrm.close();
            }
            int responseCode = connection.getResponseCode();
            this.log.debug("Mapping.txt upload returns [" + responseCode + "]");
            switch (responseCode) {
                case 200: {
                    this.log.info("Mapping.txt updated.");
                    return;
                }
                case 201: {
                    this.log.info("Successfully sent ProGuard/DexGuard 'mapping.txt' to New Relic.");
                    return;
                }
                case 202: {
                    this.log.info("Successfully sent ProGuard/DexGuard 'mapping.txt' to New Relic for background processing.");
                    return;
                }
                case 400: {
                    String response;
                    try (InputStream inputStream = connection.getErrorStream();){
                        response = Streams.slurp((InputStream)inputStream, (String)"UTF-8");
                        if (Strings.isNullOrEmpty((String)response)) {
                            response = connection.getResponseMessage();
                        }
                        this.log.error("Unable to send ProGuard/DexGuard 'mapping.txt' to New Relic: " + response);
                        this.logRecourse();
                        return;
                    }
                }
                case 409: {
                    this.log.info("A ProGuard/DexGuard 'mapping.txt' tagged with build ID [" + buildId + "] has already been stored.");
                    return;
                }
                default: {
                    String response;
                    InputStream inputStream;
                    if (responseCode > 400) {
                        inputStream = connection.getErrorStream();
                        try {
                            response = Streams.slurp((InputStream)inputStream, (String)"UTF-8");
                            if (Strings.isNullOrEmpty((String)response)) {
                                response = connection.getResponseMessage();
                            }
                            this.log.error("Unable to send ProGuard/DexGuard 'mapping.txt' to New Relic - received status " + responseCode + ": " + response);
                            this.logRecourse();
                            return;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    this.log.error("ProGuard/DexGuard 'mapping.txt' upload return [" + responseCode + "]");
                    return;
                }
            }
        }
        catch (Exception e) {
            this.log.error("An error occurred uploading ProGuard/DexGuard 'mapping.txt' to New Relic: " + e.getLocalizedMessage());
            this.logRecourse();
            return;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void logRecourse() {
        this.log.error("To de-obfuscate crashes, upload the build's ProGuard/DexGuard 'mapping.txt' manually,");
        this.log.error("or run the 'newRelicMapUpload<Variant>' or 'newRelicProguardScanTask' Gradle tasks.");
        this.log.error("For more help, see 'https://docs.newrelic.com/docs/mobile-monitoring/new-relic-mobile-android/install-configure/android-agent-crash-reporting'");
    }

    String parseRegionFromApplicationToken(String applicationToken) {
        if (null == applicationToken || "".equals(applicationToken)) {
            return null;
        }
        Pattern pattern = Pattern.compile("^(.+?)x{1,2}.*");
        Matcher matcher = pattern.matcher(applicationToken);
        if (matcher.matches()) {
            try {
                String prefix = matcher.group(1);
                if (prefix != null && !"".equals(prefix)) {
                    return prefix;
                }
                this.log.warn("Region prefix empty");
            }
            catch (Exception e) {
                this.log.error("getRegionalCollectorFromLicenseKey: " + e);
            }
        }
        return null;
    }

    static class MultipartFormWriter {
        static final String boundary = "===" + System.currentTimeMillis() + "===";
        static final String newLn = System.getProperty("line.separator", "\r\n");
        final OutputStream os;
        final int bufferSz;

        private void writeString(String string) throws IOException {
            this.os.write(string.getBytes());
        }

        public MultipartFormWriter(DataOutputStream dos, int bufferSz) {
            this.os = dos;
            this.bufferSz = bufferSz;
        }

        void writeFilePart(String partName, File filePart, InputStream is) throws IOException {
            this.writeString("--" + boundary + newLn);
            this.writeString("Content-Disposition: form-data; name=\"" + partName + "\"; filename=\"" + filePart.getName() + "\"" + newLn);
            this.writeString("Content-Type: " + URLConnection.guessContentTypeFromName(filePart.getName()) + newLn);
            this.writeString("Content-Transfer-Encoding: binary" + newLn + newLn);
            Streams.copy((InputStream)is, (OutputStream)this.os, (int)this.bufferSz);
        }

        public void finish() throws IOException {
            this.writeString(newLn + "--" + boundary + "--" + newLn);
        }
    }

    public static class Provider {
        public static final String PROGUARD_603 = "proguard:6.0.3";
        public static final String DEXGUARD = "dexguard";
        public static final String R8 = "r8";
        public static final String DEFAULT = "r8";

        public static String decompose(String mapProvider) {
            String[] parts = mapProvider.split("[:]");
            String header = Proguard.NR_COMPILER_PREFIX + mapProvider + NEWLN;
            if (parts.length > 0) {
                header = Proguard.NR_COMPILER_PREFIX + parts[0] + NEWLN;
                if (parts.length > 1) {
                    header = header + Proguard.NR_COMPILER_VERSION_PREFIX + parts[1] + NEWLN;
                }
            }
            return header;
        }
    }

    static final class Network {
        public static final String APPLICATION_LICENSE_HEADER = "X-App-License-Key";
        public static final String REQUEST_DEBUG_HEADER = "X-APP-REQUEST-DEBUG";
        public static final String CONTENT_LENGTH_HEADER = "Content-Length";

        Network() {
        }

        static final class ContentType {
            public static final String HEADER = "Content-Type";
            public static final String URL_ENCODED = "application/x-www-form-urlencoded";
            public static final String MULTIPART_FORM_DATA = "multipart/form-data";

            ContentType() {
            }
        }
    }
}

