/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import android.content.Context;
import com.newrelic.agent.android.AndroidAgentImpl;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.logging.AndroidAgentLog;
import com.newrelic.agent.android.logging.NullAgentLog;

public class NewRelic {
    private static final String DEFAULT_COLLECTOR_ADDR = "mobile-collector.newrelic.com";
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final String token;
    private String appName;
    private String collectorAddress = "mobile-collector.newrelic.com";
    private boolean ssl = true;
    private boolean loggingEnabled = true;
    private boolean locationServicesEnabled = false;

    private NewRelic(String token) {
        this.token = token;
    }

    public static NewRelic withApplicationToken(String token) {
        return new NewRelic(token);
    }

    public NewRelic usingSsl(boolean useSsl) {
        this.ssl = useSsl;
        return this;
    }

    public NewRelic usingCollectorAddress(String address) {
        this.collectorAddress = address;
        return this;
    }

    public NewRelic withLocationServiceEnabled(boolean enabled) {
        this.locationServicesEnabled = enabled;
        return this;
    }

    public NewRelic withLoggingEnabled(boolean enabled) {
        this.loggingEnabled = enabled;
        return this;
    }

    public void start(Context context) {
        try {
            AgentLogManager.setAgentLog(this.loggingEnabled ? new AndroidAgentLog() : new NullAgentLog());
            AndroidAgentImpl.init(context, this.token, this.collectorAddress, this.ssl, this.locationServicesEnabled, this.appName);
        }
        catch (Throwable e) {
            log.error("Error occurred while starting the New Relic agent!", e);
        }
    }
}

