/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.api.common;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONObject;

public class ErrorData {
    private final String url;
    private final int httpStatusCode;
    private int count;
    private final String responseBody;
    private final String stackTrace;
    private final Map<String, Object> params;
    private final String digest;
    private static final AgentLog log = AgentLogManager.getAgentLog();

    public ErrorData(String url, int httpStatusCode, String responseBody, Map<String, Object> params) {
        this.url = url;
        this.httpStatusCode = httpStatusCode;
        this.count = 1;
        this.responseBody = responseBody;
        this.stackTrace = this.getSanitizedStackTrace();
        this.params = params;
        this.digest = this.computeHash();
    }

    public String getUrl() {
        return this.url;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public int getCount() {
        return this.count;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getHash() {
        return this.digest;
    }

    public List<Object> asList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.url);
        list.add(this.httpStatusCode);
        list.add(this.count);
        list.add(this.responseBody);
        list.add(this.stackTrace);
        TreeMap<String, JSONObject> custom_params = new TreeMap<String, JSONObject>();
        custom_params.put("custom_params", new JSONObject(this.params));
        list.add(new JSONObject(custom_params));
        return list;
    }

    public void incrementCount() {
        ++this.count;
    }

    public String computeHash() {
        MessageDigest digester;
        try {
            digester = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Unable to initialize SHA-1 hash algorithm");
            return null;
        }
        digester.update(this.url.getBytes());
        digester.update(ByteBuffer.allocate(8).putInt(this.httpStatusCode).array());
        if (this.stackTrace != null && this.stackTrace.length() > 0) {
            digester.update(this.stackTrace.getBytes());
        }
        return new String(digester.digest());
    }

    public String getSanitizedStackTrace() {
        StringBuilder stackTrace = new StringBuilder();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        int numErrors = 0;
        for (int i = 0; i < stackTraceElements.length; ++i) {
            StackTraceElement frame = stackTraceElements[i];
            if (this.shouldFilterStackTraceElement(frame)) continue;
            stackTrace.append(frame.toString());
            if (i <= stackTraceElements.length - 1) {
                stackTrace.append("\n");
            }
            if (++numErrors >= Agent.getStackTraceLimit()) break;
        }
        return stackTrace.toString();
    }

    private boolean shouldFilterStackTraceElement(StackTraceElement element) {
        String className = element.getClassName();
        String method = element.getMethodName();
        if (className.startsWith("com.newrelic")) {
            return true;
        }
        if (className.startsWith("dalvik.system.VMStack") && method.startsWith("getThreadStackTrace")) {
            return true;
        }
        return className.startsWith("java.lang.Thread") && method.startsWith("getStackTrace");
    }
}

