/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.api.v1;

import com.newrelic.agent.android.api.v1.DeviceInfo;
import java.util.Collection;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class SimpleDeviceInfo
implements DeviceInfo {
    private final JSONArray jsonArray;

    public SimpleDeviceInfo() {
        this(null, null, null, null, null, null, null, null);
    }

    public SimpleDeviceInfo(String osName, String osVersion, String manufacturer, String model, String agentName, String agentVersion, String deviceId, Map<String, String> misc) {
        this.jsonArray = SimpleDeviceInfo.newJSONArray(osName, osVersion, manufacturer + " " + model, agentName, agentVersion, deviceId, null, null, manufacturer, misc);
    }

    private SimpleDeviceInfo(JSONArray array) throws JSONException {
        this.jsonArray = new JSONArray();
        for (int i = 0; i < array.length(); ++i) {
            this.jsonArray.put(array.get(i));
        }
    }

    public SimpleDeviceInfo withLocation(String countryCode, String regionCode) throws JSONException {
        SimpleDeviceInfo deviceInfo = new SimpleDeviceInfo(this.jsonArray);
        deviceInfo.setCountryCode(countryCode);
        deviceInfo.setRegionCode(regionCode);
        return deviceInfo;
    }

    public JSONArray toJSONArray() {
        return this.jsonArray;
    }

    public void setOsName(String osName) throws JSONException {
        this.put(Field.OS_NAME, osName);
    }

    public void setOsVersion(String osVersion) throws JSONException {
        this.put(Field.OS_VERSION, osVersion);
    }

    public void setModel(String model) throws JSONException {
        this.put(Field.MANUFACTURER_MODEL, model);
    }

    public void setAgentName(String agentName) throws JSONException {
        this.put(Field.AGENT_NAME, agentName);
    }

    public void setAgentVersion(String agentVersion) throws JSONException {
        this.put(Field.AGENT_VERSION, agentVersion);
    }

    public void setDeviceId(String deviceId) throws JSONException {
        this.put(Field.DEVICE_ID, deviceId);
    }

    public void setCountryCode(String countryCode) throws JSONException {
        this.put(Field.COUNTRY_CODE, countryCode);
    }

    public void setRegionCode(String regionCode) throws JSONException {
        this.put(Field.REGION_CODE, regionCode);
    }

    public void setManufacturer(String manufacturer) throws JSONException {
        this.put(Field.MANUFACTURER, manufacturer);
    }

    public void setMisc(Map<String, String> misc) throws JSONException {
        this.put(Field.MISC, misc);
    }

    public String toString() {
        return this.toJSONArray().toString();
    }

    private void put(Field field, Object value) throws JSONException {
        this.jsonArray.put(field.ordinal(), SimpleDeviceInfo.convertValue(value));
    }

    private static Object convertValue(Object arg) {
        if (arg instanceof Collection) {
            return new JSONArray((Collection)arg);
        }
        if (arg instanceof Map) {
            return new JSONObject((Map)arg);
        }
        if (arg == null) {
            return JSONObject.NULL;
        }
        return arg;
    }

    private static JSONArray newJSONArray(Object ... args) {
        JSONArray arr = new JSONArray();
        for (Object arg : args) {
            arr.put(SimpleDeviceInfo.convertValue(arg));
        }
        return arr;
    }

    private static enum Field {
        OS_NAME,
        OS_VERSION,
        MANUFACTURER_MODEL,
        AGENT_NAME,
        AGENT_VERSION,
        DEVICE_ID,
        COUNTRY_CODE,
        REGION_CODE,
        MANUFACTURER,
        MISC;

    }
}

