/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.background;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.api.common.ErrorData;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.api.v1.NewRelicApi;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stats.TicToc;
import com.newrelic.agent.android.transport.TransportException;
import com.newrelic.agent.android.util.ConnectivitySampler;
import com.newrelic.agent.android.util.MachineMeasurementsSampler;
import java.io.InterruptedIOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class HarvestHeartbeat
implements Runnable {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final NewRelicApi api1;
    private long harvestInterval;
    private TimeUnit harvestIntervalUnit;
    private final long minDeltaTime;
    private final TimeUnit deltaTimeUnit;
    private final ScheduledThreadPoolExecutor executor;
    private ScheduledFuture<?> future;
    private long lastTime;
    private long sessionStartTime;
    private Thread finalThread;
    private final Object finalThreadLock = new Object();
    private final MachineMeasurementsSampler machineMeasurementsSampler;
    private final ConnectivitySampler connectivitySampler;
    private boolean stopped = false;
    private boolean stopRequested = false;
    private boolean harvesting = false;
    private boolean needConnect;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition stopCond = this.lock.newCondition();
    private final Condition harvestCond = this.lock.newCondition();
    private long harvestCounter = 0L;

    public HarvestHeartbeat(NewRelicApi api, MachineMeasurementsSampler machineMeasurementsSampler, ConnectivitySampler connectivitySampler, long harvestIntervalInMilliseconds) {
        this(api, machineMeasurementsSampler, connectivitySampler, harvestIntervalInMilliseconds, TimeUnit.MILLISECONDS, (long)((double)harvestIntervalInMilliseconds * 0.8333333333333334), TimeUnit.MILLISECONDS);
    }

    public HarvestHeartbeat(NewRelicApi api1, MachineMeasurementsSampler machineMeasurementsSampler, ConnectivitySampler connectivitySampler, long harvestInterval, TimeUnit harvestTimeUnit, long minDeltaTime, TimeUnit deltaTimeUnit) {
        this.api1 = api1;
        this.harvestInterval = harvestInterval;
        this.harvestIntervalUnit = harvestTimeUnit;
        this.minDeltaTime = minDeltaTime;
        this.deltaTimeUnit = deltaTimeUnit;
        this.machineMeasurementsSampler = machineMeasurementsSampler;
        this.connectivitySampler = connectivitySampler;
        this.executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "[New Relic] Heartbeat");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(long harvestInterval, TimeUnit unit) {
        this.lock.lock();
        try {
            if (this.stopRequested) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        HarvestHeartbeat harvestHeartbeat = this;
        synchronized (harvestHeartbeat) {
            if (unit.convert(this.harvestInterval, this.harvestIntervalUnit) != harvestInterval) {
                this.harvestInterval = harvestInterval;
                this.harvestIntervalUnit = unit;
                log.info("Setting heartbeat interval to " + harvestInterval + " " + unit.name().toLowerCase());
                if (this.future != null) {
                    log.debug("Restarting the executor with the new heartbeat interval");
                    this.future.cancel(true);
                    this.future = this.executor.scheduleAtFixedRate(this, harvestInterval, harvestInterval, this.harvestIntervalUnit);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean needConnect) {
        HarvestHeartbeat harvestHeartbeat = this;
        synchronized (harvestHeartbeat) {
            if (this.future == null) {
                this.lock.lock();
                try {
                    this.stopRequested = false;
                    this.needConnect = needConnect;
                }
                finally {
                    this.lock.unlock();
                }
                this.lastTime = System.currentTimeMillis();
                this.sessionStartTime = System.nanoTime();
                this.future = this.executor.scheduleAtFixedRate(this, needConnect ? 0L : this.harvestInterval, this.harvestInterval, this.harvestIntervalUnit);
                log.info(MessageFormat.format("Harvest thread started [interval: {0} {1}, minDelta: {2} {3}]", this.harvestInterval, this.harvestIntervalUnit.name().toLowerCase(), this.minDeltaTime, this.deltaTimeUnit.name().toLowerCase()));
            }
        }
    }

    public void stop() {
        this.stop(true);
    }

    public void dispose() {
        this.stop(false);
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean doSendData) {
        this.lock.lock();
        try {
            this.stopRequested = true;
            this.stopped = false;
            this.needConnect = false;
        }
        finally {
            this.lock.unlock();
        }
        HarvestHeartbeat harvestHeartbeat = this;
        synchronized (harvestHeartbeat) {
            if (this.future != null) {
                long sessionStartTime = this.sessionStartTime;
                this.sessionStartTime = 0L;
                this.future.cancel(true);
                this.future = null;
                log.info("Harvest thread stopped");
                if (doSendData) {
                    long lastHarvestTime = this.lastTime;
                    this.finalSendData(sessionStartTime, lastHarvestTime);
                } else {
                    this.afterStop();
                }
            } else {
                this.afterStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalSendData(final long sessionStartTime, final long lastHarvestTime) {
        final long thisTime = System.currentTimeMillis();
        Object object = this.finalThreadLock;
        synchronized (object) {
            if (this.finalThread == null) {
                log.debug("Sending final data in background.");
                this.finalThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        try {
                            HarvestHeartbeat.access$000(HarvestHeartbeat.this).lock();
                            ** try [egrp 1[TRYBLOCK] [3 : 10->47)] { 
lbl4:
                            // 1 sources

                            ** GOTO lbl-1000
lbl5:
                            // 1 sources

                            finally {
                                HarvestHeartbeat.access$000(HarvestHeartbeat.this).unlock();
                            }
                        }
                        catch (Exception e) {
                            HarvestHeartbeat.access$300().error("Failed to send final post", e);
                            return;
                        }
lbl-1000:
                        // 2 sources

                        {
                            while (HarvestHeartbeat.access$100(HarvestHeartbeat.this)) {
                                try {
                                    HarvestHeartbeat.access$200(HarvestHeartbeat.this).await();
                                }
                                catch (InterruptedException e) {
                                    HarvestHeartbeat.access$300().error("Interrupted waiting for harvest to finish", e);
                                    HarvestHeartbeat.access$000(HarvestHeartbeat.this).unlock();
                                    var2_5 = HarvestHeartbeat.access$700(HarvestHeartbeat.this);
                                    synchronized (var2_5) {
                                        HarvestHeartbeat.access$802(HarvestHeartbeat.this, null);
                                    }
                                    HarvestHeartbeat.access$300().info("Background thread has completed");
                                    HarvestHeartbeat.access$900(HarvestHeartbeat.this);
                                    return;
                                }
                            }
                        }
                        transactions = Agent.getAndClearTransactionData();
                        errors = Agent.getAndClearErrorData();
                        sessionEndTime = System.nanoTime();
                        sessionTime = (double)(sessionEndTime - sessionStartTime) / 1.0E9;
                        if (HarvestHeartbeat.access$400(HarvestHeartbeat.this).sample() == false) return;
                        HarvestHeartbeat.access$600(HarvestHeartbeat.this).sendData((double)(thisTime - lastHarvestTime) / 1000.0, (Collection<TransactionData>)transactions, errors, HarvestHeartbeat.access$500(HarvestHeartbeat.this).sample(), sessionTime);
                        StatsEngine.reset();
                        return;
                        finally {
                            var1_4 = HarvestHeartbeat.access$700(HarvestHeartbeat.this);
                            synchronized (var1_4) {
                                HarvestHeartbeat.access$802(HarvestHeartbeat.this, null);
                            }
                            HarvestHeartbeat.access$300().info("Background thread has completed");
                            HarvestHeartbeat.access$900(HarvestHeartbeat.this);
                        }
                    }
                };
                this.finalThread.start();
            } else {
                log.debug("Final session data thread already running: will not fire again.");
                Agent.getAndClearTransactionData();
                Agent.getAndClearErrorData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterStop() {
        this.lock.lock();
        try {
            if (this.stopRequested) {
                this.stopRequested = false;
            }
            this.stopped = true;
            this.stopCond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForStop(long time, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.stopped) {
                if (this.stopCond.await(time, unit)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForHarvest(long time, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            Date deadline = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(time, unit));
            long counterValue = this.harvestCounter;
            while (this.harvestCounter == counterValue) {
                if (this.harvestCond.awaitUntil(deadline)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean needConnect;
            long thisTime = System.currentTimeMillis();
            this.lock.lock();
            try {
                needConnect = this.needConnect;
                if (needConnect) {
                    this.needConnect = false;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (needConnect) {
                log.info("Connecting!");
                try {
                    this.api1.sendConnect();
                }
                catch (InterruptedIOException e) {
                    log.error("Harvested interrupted during I/O operation: " + e.getMessage(), e);
                }
            } else {
                log.info("Heartbeat [" + (thisTime - this.lastTime) + "ms elapsed]");
                try {
                    this.harvest(thisTime - this.lastTime);
                }
                catch (InterruptedIOException e) {
                    log.error("Harvester interrupted during an I/O operation: " + e.getMessage(), e);
                }
            }
            HarvestHeartbeat harvestHeartbeat = this;
            synchronized (harvestHeartbeat) {
                this.lastTime = thisTime;
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void harvest(long delta) throws InterruptedIOException {
        this.lock.lock();
        try {
            if (this.harvesting) {
                log.verbose("A harvest is already in progress. Come back later.");
                return;
            }
            this.harvesting = true;
        }
        finally {
            this.lock.unlock();
        }
        try {
            List<ErrorData> errorData;
            List<TransactionData> transactionData;
            block35: {
                if (delta < TimeUnit.MILLISECONDS.convert(this.minDeltaTime, this.deltaTimeUnit)) {
                    log.verbose("Skipping harvest heartbeat - too soon");
                    return;
                }
                Object object = this.finalThreadLock;
                synchronized (object) {
                    if (this.finalThread != null) {
                        log.warning("Previous heartbeat is still shutting down -- skipping harvest ...");
                        return;
                    }
                }
                transactionData = Agent.getAndClearTransactionData();
                errorData = Agent.getAndClearErrorData();
                TicToc timer = new TicToc();
                try {
                    if (!this.isOnline()) break block35;
                    this.lock.lock();
                    try {
                        if (this.stopRequested) {
                            log.warning("Stop requested after the harvest started -- skipping harvest ...");
                            this.lock.unlock();
                            return;
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                catch (TransportException e) {
                    log.error("Failed to send transaction data", e);
                    Agent.mergeTransactionData(transactionData);
                    Agent.mergeErrorData(errorData);
                    return;
                }
                timer.tic();
                this.api1.sendData((double)delta / 1000.0, transactionData, errorData, this.machineMeasurementsSampler.sample());
                StatsEngine.get().recordTimeMs("Supportability/MobileAgent/Collector/Harvest", timer.toc());
                return;
            }
            log.debug("Radio seems to be offline. Metric data will not be sent...");
            Agent.mergeTransactionData(transactionData);
            Agent.mergeErrorData(errorData);
            return;
        }
        finally {
            this.lock.lock();
            try {
                ++this.harvestCounter;
                this.harvesting = false;
                this.harvestCond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private boolean isOnline() {
        return this.connectivitySampler.sample();
    }

    static /* synthetic */ ReentrantLock access$000(HarvestHeartbeat x0) {
        return x0.lock;
    }

    static /* synthetic */ boolean access$100(HarvestHeartbeat x0) {
        return x0.harvesting;
    }

    static /* synthetic */ Condition access$200(HarvestHeartbeat x0) {
        return x0.harvestCond;
    }

    static /* synthetic */ AgentLog access$300() {
        return log;
    }

    static /* synthetic */ ConnectivitySampler access$400(HarvestHeartbeat x0) {
        return x0.connectivitySampler;
    }

    static /* synthetic */ MachineMeasurementsSampler access$500(HarvestHeartbeat x0) {
        return x0.machineMeasurementsSampler;
    }

    static /* synthetic */ NewRelicApi access$600(HarvestHeartbeat x0) {
        return x0.api1;
    }

    static /* synthetic */ Object access$700(HarvestHeartbeat x0) {
        return x0.finalThreadLock;
    }

    static /* synthetic */ Thread access$802(HarvestHeartbeat x0, Thread x1) {
        x0.finalThread = x1;
        return x0.finalThread;
    }

    static /* synthetic */ void access$900(HarvestHeartbeat x0) {
        x0.afterStop();
    }
}

