/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.webkit.WebView;
import com.newrelic.agent.android.instrumentation.InstrumentingWebViewClient;
import java.lang.reflect.Field;

public class ActivityInstrumentation {
    public static void setFactory(final LayoutInflater inflater, final LayoutInflater.Factory factory) {
        inflater.setFactory(new LayoutInflater.Factory(){

            public View onCreateView(String name, Context context, AttributeSet attrs) {
                View view = factory.onCreateView(name, context, attrs);
                if (view instanceof WebView) {
                    ((WebView)view).setWebViewClient(InstrumentingWebViewClient.DEFAULT_INSTRUMENTING_CLIENT);
                } else if (view == null) {
                    return ActivityInstrumentation.onCreateView(inflater, name, attrs);
                }
                return view;
            }
        });
    }

    public static void onCreate(Activity activity) {
        final LayoutInflater layoutInflater = activity.getLayoutInflater();
        try {
            Field declaredField = LayoutInflater.class.getDeclaredField("mFactorySet");
            declaredField.setAccessible(true);
            declaredField.set(layoutInflater, false);
            layoutInflater.setFactory(new LayoutInflater.Factory(){

                public View onCreateView(String name, Context context, AttributeSet attrs) {
                    return ActivityInstrumentation.onCreateView(layoutInflater, name, attrs);
                }
            });
            declaredField.set(layoutInflater, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static View onCreateView(LayoutInflater layoutInflater, String name, AttributeSet attrs) {
        if ("WebView".equals(name)) {
            try {
                WebView view = (WebView)layoutInflater.createView(name, "android.webkit.", attrs);
                view.setWebViewClient(InstrumentingWebViewClient.DEFAULT_INSTRUMENTING_CLIENT);
                return view;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

