/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.httpclient;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.api.common.ErrorData;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.io.CountingInputStream;
import com.newrelic.agent.android.instrumentation.io.CountingOutputStream;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteEvent;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListener;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListenerSource;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public final class HttpResponseEntityImpl
implements HttpEntity,
StreamCompleteListener {
    private final HttpEntity impl;
    private final TransactionState transactionState;
    private final long contentLengthFromHeader;
    private CountingInputStream contentStream;
    private static final AgentLog log = AgentLogManager.getAgentLog();

    public HttpResponseEntityImpl(HttpEntity impl, TransactionState transactionState, long contentLengthFromHeader) {
        this.impl = impl;
        this.transactionState = transactionState;
        this.contentLengthFromHeader = contentLengthFromHeader;
    }

    public void consumeContent() throws IOException {
        try {
            this.impl.consumeContent();
        }
        catch (IOException e) {
            TransactionStateUtil.setErrorCodeFromException(this.transactionState, e);
            if (!this.transactionState.isComplete()) {
                Agent.addTransactionData(this.transactionState.end());
            }
            throw e;
        }
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        if (this.contentStream != null) {
            return this.contentStream;
        }
        try {
            this.contentStream = new CountingInputStream(this.impl.getContent(), true);
            this.contentStream.addStreamCompleteListener(this);
            return this.contentStream;
        }
        catch (IOException e) {
            TransactionStateUtil.setErrorCodeFromException(this.transactionState, e);
            if (!this.transactionState.isComplete()) {
                Agent.addTransactionData(this.transactionState.end());
            }
            throw e;
        }
    }

    public Header getContentEncoding() {
        return this.impl.getContentEncoding();
    }

    public long getContentLength() {
        return this.impl.getContentLength();
    }

    public Header getContentType() {
        return this.impl.getContentType();
    }

    public boolean isChunked() {
        return this.impl.isChunked();
    }

    public boolean isRepeatable() {
        return this.impl.isRepeatable();
    }

    public boolean isStreaming() {
        return this.impl.isStreaming();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (!this.transactionState.isComplete()) {
            CountingOutputStream outputStream = new CountingOutputStream(outstream);
            try {
                this.impl.writeTo((OutputStream)outputStream);
            }
            catch (IOException e) {
                TransactionStateUtil.setErrorCodeFromException(this.transactionState, e);
                if (!this.transactionState.isComplete()) {
                    this.transactionState.setBytesReceived(outputStream.getCount());
                    Agent.addTransactionData(this.transactionState.end());
                }
                e.printStackTrace();
                throw e;
            }
            if (!this.transactionState.isComplete()) {
                if (this.contentLengthFromHeader >= 0L) {
                    this.transactionState.setBytesReceived(this.contentLengthFromHeader);
                } else {
                    this.transactionState.setBytesReceived(outputStream.getCount());
                }
                this.addTransactionAndErrorData(this.transactionState);
            }
        } else {
            this.impl.writeTo(outstream);
        }
    }

    @Override
    public void streamComplete(StreamCompleteEvent e) {
        StreamCompleteListenerSource source = (StreamCompleteListenerSource)e.getSource();
        source.removeStreamCompleteListener(this);
        if (!this.transactionState.isComplete()) {
            if (this.contentLengthFromHeader >= 0L) {
                this.transactionState.setBytesReceived(this.contentLengthFromHeader);
            } else {
                this.transactionState.setBytesReceived(e.getBytes());
            }
            this.addTransactionAndErrorData(this.transactionState);
        }
    }

    @Override
    public void streamError(StreamCompleteEvent e) {
        StreamCompleteListenerSource source = (StreamCompleteListenerSource)e.getSource();
        source.removeStreamCompleteListener(this);
        TransactionStateUtil.setErrorCodeFromException(this.transactionState, e.getException());
        if (!this.transactionState.isComplete()) {
            this.transactionState.setBytesReceived(e.getBytes());
        }
    }

    private void addTransactionAndErrorData(TransactionState transactionState) {
        TransactionData transactionData = transactionState.end();
        Agent.addTransactionData(transactionData);
        if ((long)transactionState.getStatusCode() >= 400L) {
            StringBuilder responseBody = new StringBuilder();
            try {
                InputStream errorStream = this.getContent();
                if (errorStream instanceof CountingInputStream) {
                    responseBody.append(((CountingInputStream)errorStream).getBufferAsString());
                }
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            Header contentType = this.impl.getContentType();
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            if (contentType != null && contentType.getValue() != null && !"".equals(contentType.getValue())) {
                params.put("content_type", contentType.getValue());
            }
            params.put("content_length", transactionState.getBytesReceived());
            Agent.addErrorData(new ErrorData(transactionData.getUrl(), transactionData.getStatusCode(), responseBody.toString(), params));
        }
    }
}

