/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.transport.http;

import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stats.TicToc;
import com.newrelic.agent.android.transport.DisableAgentException;
import com.newrelic.agent.android.transport.DisconnectAgentException;
import com.newrelic.agent.android.transport.FlushTransactionDataException;
import com.newrelic.agent.android.transport.Transport;
import com.newrelic.agent.android.transport.TransportException;
import com.newrelic.agent.android.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpJsonTransport
implements Transport {
    private static final int BUFFER_SIZE = 8192;
    private static final String KILL_STRING = "DISABLE_NEW_RELIC";
    private static final int TIMEOUT_IN_SECONDS = 20;
    public static final String LICENSE_KEY_HEADER = "X-App-License-Key";
    public static final String CONNECT_TIME_HEADER = "X-NewRelic-Connect-Time";
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final String endpoint;
    private final String licenseKey;
    private final HttpClient client;

    public HttpJsonTransport(String endpoint, String licenseKey) {
        this.endpoint = endpoint;
        this.licenseKey = licenseKey;
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)((int)TimeUnit.MILLISECONDS.convert(20L, TimeUnit.SECONDS)));
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)((int)TimeUnit.MILLISECONDS.convert(20L, TimeUnit.SECONDS)));
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        this.client = new DefaultHttpClient((HttpParams)params);
    }

    private void recordCollectorError(int errorCode) {
        StatsEngine.get().inc("Supportability/MobileAgent/Collector/ResponseErrorCodes/" + errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String send(Transport.MessageType type, String message, long serverTimestamp) throws InterruptedIOException, DisableAgentException, DisconnectAgentException, FlushTransactionDataException, TransportException {
        HttpResponse response;
        String contentEncoding = message.length() <= 512 ? "identity" : "deflate";
        TicToc timer = new TicToc();
        timer.tic();
        HttpPost post = new HttpPost(this.getMessageEndpoint(type));
        post.addHeader("Content-Type", "application/json");
        post.addHeader("Content-Encoding", contentEncoding);
        post.addHeader(LICENSE_KEY_HEADER, this.licenseKey);
        post.addHeader("User-Agent", System.getProperty("http.agent"));
        if (serverTimestamp != 0L) {
            post.addHeader(CONNECT_TIME_HEADER, Long.valueOf(serverTimestamp).toString());
        }
        if ("deflate".equals(contentEncoding)) {
            byte[] deflated = this.deflate(message);
            post.setEntity((HttpEntity)new ByteArrayEntity(deflated));
        } else {
            try {
                post.setEntity((HttpEntity)new StringEntity(message, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("UTF-8 is unsupported");
                throw new TransportException(e);
            }
        }
        try {
            response = this.client.execute((HttpUriRequest)post);
        }
        catch (ClientProtocolException e) {
            log.error("HTTP protocol error during " + type.name().toLowerCase());
            this.recordCollectorError(-1011);
            throw new TransportException(e);
        }
        catch (IOException e) {
            if (e instanceof UnknownHostException) {
                this.recordCollectorError(-1006);
            } else if (e instanceof SocketTimeoutException) {
                this.recordCollectorError(-1001);
            } else if (e instanceof ConnectTimeoutException) {
                this.recordCollectorError(-1001);
            } else if (e instanceof ConnectException) {
                this.recordCollectorError(-1004);
            } else if (e instanceof MalformedURLException) {
                this.recordCollectorError(-1000);
            } else if (e instanceof SSLException) {
                this.recordCollectorError(-1200);
            } else {
                this.recordCollectorError(-1);
            }
            if (e.getClass() == InterruptedIOException.class) {
                log.warning("Interrupted during an I/O operation");
                throw (InterruptedIOException)e;
            }
            log.warning("I/O error during " + type.name().toLowerCase());
            throw new TransportException(e);
        }
        if (response.getStatusLine().getStatusCode() < 400) {
            StatsEngine.reset();
        }
        StatsEngine.get().recordTimeMs("Supportability/MobileAgent/Collector/ResponseStatusCodes/" + response.getStatusLine().getStatusCode(), timer.toc());
        if (response.getStatusLine().getStatusCode() < 400) {
            String responseJson;
            try {
                InputStream in = response.getEntity().getContent();
                try {
                    responseJson = Util.slurp(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                log.warning("Failed to read JSON response during " + type.name().toLowerCase());
                throw new TransportException(e);
            }
            return responseJson;
        }
        switch (response.getStatusLine().getStatusCode()) {
            case 401: 
            case 450: {
                throw new DisconnectAgentException();
            }
            case 403: {
                String content;
                try {
                    content = Util.slurp(response.getEntity().getContent()).trim();
                }
                catch (Throwable e) {
                    throw new TransportException(e);
                }
                if (content.equals(KILL_STRING)) {
                    throw new DisableAgentException();
                }
                throw new TransportException("Unexpected HTTP 403 from the collector");
            }
            case 413: 
            case 415: {
                throw new FlushTransactionDataException();
            }
        }
        throw new TransportException(response.getStatusLine().getStatusCode(), type.name().toLowerCase() + " failed with status code " + response.getStatusLine().getStatusCode());
    }

    private byte[] deflate(String message) throws TransportException {
        Deflater deflater = new Deflater();
        deflater.setInput(message.getBytes());
        deflater.finish();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while (!deflater.finished()) {
            int byteCount = deflater.deflate(buf);
            if (byteCount <= 0) {
                throw new TransportException("HTTP request contains an incomplete payload");
            }
            baos.write(buf, 0, byteCount);
        }
        deflater.end();
        return baos.toByteArray();
    }

    private String getMessageEndpoint(Transport.MessageType type) {
        return MessageFormat.format("{0}/{1}", this.endpoint, type.name().toLowerCase());
    }
}

