/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import com.newrelic.agent.android.AgentImpl;
import com.newrelic.agent.android.api.common.ErrorData;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.util.Encoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class NullAgentImpl
implements AgentImpl {
    public static final NullAgentImpl instance = new NullAgentImpl();
    private boolean harvestHappened = false;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition harvestCond = this.lock.newCondition();

    @Override
    public void addTransactionData(TransactionData transactionData) {
    }

    @Override
    public List<TransactionData> getAndClearTransactionData() {
        return new ArrayList<TransactionData>();
    }

    @Override
    public void mergeTransactionData(List<TransactionData> transactionDataList) {
    }

    @Override
    public void addErrorData(ErrorData transactionData) {
    }

    @Override
    public List<ErrorData> getAndClearErrorData() {
        return new ArrayList<ErrorData>();
    }

    @Override
    public void mergeErrorData(List<ErrorData> transactionDataList) {
    }

    @Override
    public String getCrossProcessId() {
        return null;
    }

    @Override
    public int getStackTraceLimit() {
        return 0;
    }

    @Override
    public int getResponseBodyLimit() {
        return 0;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void disable() {
    }

    @Override
    public boolean isDisabled() {
        return true;
    }

    @Override
    public String getNetworkCarrier() {
        return "unknown";
    }

    @Override
    public void setLocation(String countryCode, String adminRegion) {
    }

    @Override
    public boolean waitForConnect(long time, TimeUnit unit) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForHarvest(long time, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            this.harvestHappened = false;
            Date end = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(time, unit));
            while (!this.harvestHappened) {
                if (this.harvestCond.awaitUntil(end)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Encoder getEncoder() {
        return new Encoder(){

            @Override
            public String encode(byte[] bytes) {
                return new String(bytes);
            }
        };
    }
}

